<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('debits', function (Blueprint $table) {
            // Thay đổi cột debit_note từ bigInt thành longText
            $table->longText('debit_note')->nullable()->change();

            // Thêm cột debit_images với kiểu longText
            $table->longText('debit_images')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('debits', function (Blueprint $table) {
            // Khôi phục cột debit_note về bigInt
            $table->bigInteger('debit_note')->change();

            // Xóa cột debit_images nếu cần thiết
            $table->dropColumn('debit_images');
        });
    }
};
