<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_price_list_zone', function (Blueprint $table) {
            $table->id('sub_price_list_zone_id');
            $table->unsignedBigInteger('price_list_zone_id');
            $table->string('sub_price_list_zone_title');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_price_list_zone');
    }
};
