<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipment_tracking_status', function (Blueprint $table) {
            $table->id('tracking_status_id');
            $table->unsignedBigInteger('shipment_tracktry_id');
            $table->string('tracking_status_date');
            $table->string('tracking_status_address');
            $table->string('tracking_status_note');
            $table->tinyInteger('tracking_status')->default(0);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_tracking_status');
    }
};
