<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_trackings', function (Blueprint $table) {
            $table->id('package_tracking_id');
            $table->string('package_code');
            $table->string('package_tracking_date');
            $table->string('package_tracking_address');
            $table->string('package_tracking_note');
            $table->tinyInteger('package_tracking_status');
            $table->tinyInteger('active_flg')->default(ACTIVE);//
            $table->tinyInteger('delete_flg')->default(NO_DELETE);//
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_trackings');
    }
};
