<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->unsignedBigInteger('order_pickup_id')->nullable();
            $table->unsignedBigInteger('fwd_id')->nullable();
            $table->decimal('sender_longitude', 15, 12)->nullable()->after('sender_address'); // Kinh độ
            $table->decimal('serder_latitude', 15, 12)->nullable()->after('sender_address');  // Vĩ độ

            $table->foreign('order_pickup_id')->references('order_pickup_id')->on('orders_pickup')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
