<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('initiallize_label_histories', function (Blueprint $table) {
            $table->id('initiallize_label_history_id');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('shipment_id')->nullable();
            $table->json('result_call_api')->nullable()->comment('Kết quả gọi api');
            $table->integer('initiallize_label_history_kind')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('initiallize_label_histories');
    }
};
