<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('associate_with_service', function (Blueprint $table) {
            $table->id('associate_with_service_id');
            $table->unsignedBigInteger('service_id')->comment('Id dịch vụ');
            $table->json('associate_types')->comment('Mảng chứa các loại api');
            $table->timestamps();

            $table->foreign('service_id')->references('service_id')->on('services')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('associate_with_service');
    }
};
