<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bag_codes', function (Blueprint $table) {
            // Change total_package and total_weight to double
            $table->double('total_package')->default(0)->change();
            $table->double('total_weight')->default(0)->change();

            // Add ref_code column
            $table->string('ref_code')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bag_codes', function (Blueprint $table) {
            // Revert total_package and total_weight back to integer
            $table->integer('total_package')->nullable()->change();
            $table->integer('total_weight')->nullable()->change();

            // Drop ref_code column
            $table->dropColumn('ref_code');
        });
    }
};
