<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bag_codes', function (Blueprint $table) {
            $table->id('bag_code_id');
            $table->integer('bag_code_kind'); // 0 là nomal 1 là uk
            $table->string('dest_code')->nullable();
            $table->integer('branch_id');
            $table->integer('count_bag')->default(1);
            $table->integer('total_package')->nullable();
            $table->integer('total_weight')->nullable();
            $table->string('bag_code_type')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bag_codes');
    }
};
