<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipper_locations', function (Blueprint $table) {
            $table->id('shipper_location_id');
            $table->unsignedBigInteger('shipper_id');
            $table->decimal('shipper_longitude', 15, 12)->nullable(); // Kinh độ
            $table->decimal('shipper_latitude', 15, 12)->nullable();  // Vĩ độ
            $table->string('location_address', 225)->nullable();
            $table->tinyInteger('ship_status')->default(PENDING);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipper_locations');
    }
};
