<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('history_edit_shipments', function (Blueprint $table) {
            $table->id('history_edit_shipment_id');
            $table->unsignedBigInteger('shipment_id');
            $table->unsignedInteger('edit_by');
            $table->string('edit_at');
            $table->timestamps();

            $table->foreign('shipment_id')->references('shipment_id')->on('shipments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('history_edit_shipments');
    }
};
