<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_link_fwds', function (Blueprint $table) {
            $table->id('sale_link_fwd_id');
            $table->unsignedBigInteger('sale_id');
            $table->unsignedBigInteger('fwd_id');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
            
            $table->foreign('fwd_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('sale_id')->references('user_id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_link_fwds');
    }
};
