<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('range_kpis', function (Blueprint $table) {
            $table->id('range_kpi_id');
            $table->unsignedBigInteger('sale_kpi_id');
            $table->string('range_kpi_name'); 
            $table->float('salary', 20, 2); // tiền lương
            $table->float('profit_start', 20, 2); // hạn mức bắt đầu
            $table->float('profit_end', 20, 2); // hạn mức kết thúc
            $table->integer('ratio_commission'); // tỉ lệ hoa hồng
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('sale_kpi_id')->references('sale_kpi_id')->on('sale_kpis')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('range_kpis');
    }
};
