<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_kpis', function (Blueprint $table) {
            $table->id('sale_kpi_id');
            $table->string('kpi_name');
            $table->tinyInteger('kpi_kind');
            $table->tinyInteger('time_kind');
            $table->string('time_start')->nullable();
            $table->string('time_end')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_kpis');
    }
};
