<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_members', function (Blueprint $table) {
            $table->id('sale_member_id');
            $table->unsignedBigInteger('sale_team_id');
            $table->unsignedBigInteger('user_id');
            $table->tinyInteger('member_kind')->default(SALE_MEMBER);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('sale_team_id')->references('sale_team_id')->on('sales_teams')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_members');
    }
};
