<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('debits', function (Blueprint $table) {
            $table->id('debit_id');
            $table->string('debit_no')->unique(); 
            $table->bigInteger('customer_id'); 
            $table->bigInteger('created_by'); 
            $table->bigInteger('debit_note'); 
            $table->tinyInteger('debit_status')->default(0); 
            $table->tinyInteger('debit_type'); 
            $table->tinyInteger('active_flg')->default(ACTIVE); 
            $table->tinyInteger('delete_flg')->default(NO_DELETE); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('debitts');
    }
};
