<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sms_histories', function (Blueprint $table) {
            $table->id('sms_history_id');
            $table->string('phone');
            $table->string('content');
            $table->string('bill_code')->nullable();
            $table->bigInteger('send_by');
            $table->bigInteger('send_to');
            $table->tinyInteger('status')->default(0); // 0 fail, 1 success
            $table->longText('status_content')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);//
            $table->tinyInteger('delete_flg')->default(NO_DELETE);//
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sms_histories');
    }
};
