<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_surchage_goods', function (Blueprint $table) {
            $table->id('package_surchage_good_id');
            $table->integer('surcharge_goods_id');
            $table->integer('package_id');
            $table->float('price', 15);
            $table->integer('count');
            $table->tinyInteger('active_flg')->default(ACTIVE);//
            $table->tinyInteger('delete_flg')->default(NO_DELETE);//
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_surchage_goods');
    }
};
