<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipments_tracktry', function (Blueprint $table) {
            $table->id('sm_tracktry_id');
            $table->string('awb_code');
            $table->string('hawb_no')->nullable();
            $table->string('service');
            $table->string('service_ids');
            $table->integer('branch_id');//
            $table->string('airline')->nullable();//
            $table->string('partner')->nullable();//
            $table->string('dest')->nullable();//
            $table->tinyInteger('active_flg')->default(ACTIVE);//
            $table->tinyInteger('delete_flg')->default(NO_DELETE);//
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipments_tracktry');
    }
};
