<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('labels_nz', function (Blueprint $table) {
            // `id_name`, `link`, `datetime`, `referenceNo`, `state`, `postcode`,`service_code`
            $table->id('label_id');
            $table->bigInteger('create_by');
            $table->string('label_code');
            $table->longText('link')->nullable();
            $table->string('reference_no');
            $table->string('state');
            $table->string('post_code');
            $table->string('service_code');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('labels_nz');
    }
};
