<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            //Chốt bill
            $table->string('shipment_close_bill')->nullable()->after('save_receiver_flg');
            $table->string('shipment_hawb_code')->nullable()->after('shipment_close_bill');
            //Cước nội địa
            $table->float('shipment_domestic_charges', 50)->default(0)->after('shipment_amount_vat');
            //Cước thu hộ
            $table->float('shipment_collection_fee', 50)->default(0)->after('shipment_domestic_charges');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
