<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipment_operating_costs', function (Blueprint $table) {
            $table->id('shipment_operating_cost_id');
            $table->unsignedBigInteger('shipment_id');
            $table->unsignedBigInteger('operating_cost_id');
            $table->float('shipment_operating_cost_amount', 50)->default(0);
            $table->string('shipment_operating_cost_quantity')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('shipment_id')->references('shipment_id')->on('shipments')->onDelete('cascade');
            $table->foreign('operating_cost_id')->references('operating_cost_id')->on('operating_costs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_operating_costs');
    }
};
