<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('operating_costs', function (Blueprint $table) {
            $table->id('operating_cost_id');
            $table->bigInteger('parent_operating_cost_id')->nullable();
            $table->string('operating_cost_name')->nullable();
            $table->float('operating_cost_amount', 50)->default(0);
            $table->longText('operating_cost_description')->nullable();
            $table->tinyInteger('operating_cost_type')->default(OPERATING_COST_TYPE_NORMAL);
            $table->tinyInteger('operating_cost_package_number_flg')->default(OPERATING_COST_NO_USE_NUMBER_PACKAGES);
            $table->tinyInteger('operating_cost_default_flg')->default(OPERATING_COST_PENDING_COMPUTE);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('operating_costs');
    }
};
