<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            //Tổng thu khách
            $table->float('shipment_amount_total_customer', 50)->default(0)->after('shipment_amount_transport');
            //Chi phí Phụ Thu
            $table->float('shipment_amount_surcharge', 50)->default(0)->after('shipment_amount_total_customer');
            //Cước phí bảo hiểm
            $table->float('shipment_amount_insurance', 50)->default(0)->after('shipment_amount_surcharge');
            //Giá cước VAT
            $table->float('shipment_amount_vat', 50)->default(0)->after('shipment_amount_insurance');
            //Cước gốc
            $table->float('shipment_amount_original', 50)->default(0)->after('shipment_amount_vat');
            //Giá trị bảo hiểm
            $table->float('shipment_amount_insurance_value', 50)->default(0)->after('shipment_amount_original');
            //Lợi nhuận thực tế
            $table->float('shipment_amount_profit', 50)->default(0)->after('shipment_amount_insurance_value');
            //Cước phí vận hành công ty
            $table->float('shipment_amount_operating_costs', 50)->default(0)->after('shipment_amount_profit');
            $table->longText('shipment_file_label')->nullable()->after('shipment_amount_operating_costs');
            $table->longText('shipment_file_proof_of_payment')->nullable()->after('shipment_file_label');
            $table->integer('shipment_payment_method')->default(PAYMENT_METHOD_BANK)->after('shipment_file_proof_of_payment');

            $table->string('receiver_sms_name')->nullable()->after('save_receiver_flg');
            $table->string('receiver_sms_phone')->nullable()->after('receiver_sms_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
