<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('price_list_user', function (Blueprint $table) {
            $table->id('price_list_user_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('price_list_id');
            $table->unsignedBigInteger('child_price_list_id');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('price_list_id')->references('price_list_id')->on('price_list')->onDelete('cascade');
            $table->foreign('child_price_list_id')->references('child_price_list_id')->on('child_price_list')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('price_list_user');
    }
};
