<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id('invoice_id');
            $table->unsignedBigInteger('shipment_id');
            $table->string('invoice_code')->nullable();
            $table->string('invoice_goods_details')->nullable();
            $table->float('invoice_quantity', 50)->nullable();
            $table->integer('invoice_unit')->default(INVOICE_UNIT_PCS);
            $table->float('invoice_price', 50)->nullable();
            $table->float('invoice_total_price', 50)->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('shipment_id')->references('shipment_id')->on('shipments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
