<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id('package_id');
            $table->unsignedBigInteger('shipment_id');
            $table->string('package_code')->nullable();
            $table->bigInteger('package_quantity');
            $table->integer('package_type')->default(PACKAGE_TYPE_CARTON);
            $table->string('package_description');
            $table->float('package_length', 50);
            $table->float('package_width', 50);
            $table->float('package_height', 50);
            $table->float('package_weight', 50);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('shipment_id')->references('shipment_id')->on('shipments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
