<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id('shipment_id');
            $table->string('shipment_code')->unique();
            $table->unsignedBigInteger('shipment_service_id');
            $table->tinyInteger('shipment_signature_flg')->default(SHIPMENT_SIGNATURE_NO);
            $table->unsignedBigInteger('shipment_branch_id');
            $table->string('shipment_reference_code')->nullable();
            $table->integer('shipment_status')->default(SHIPMENT_STATUS_CREATE_BILL);
            $table->string('shipment_goods_name')->nullable();
            $table->float('shipment_value', 50)->nullable();
            $table->integer('shipment_export_as')->default(INVOICE_EXPORT_AS_GIFT);

            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('receiver_id')->nullable();
            $table->string('sender_company_name');
            $table->string('sender_contact_name');
            $table->string('sender_telephone');
            $table->integer('sender_city');
            $table->integer('sender_district');
            $table->integer('sender_ward');
            $table->string('sender_address');

            $table->string('receiver_company_name');
            $table->string('receiver_contact_name');
            $table->string('receiver_telephone');
            $table->unsignedBigInteger('receiver_country_id');
            $table->unsignedBigInteger('receiver_state_id')->nullable();
            $table->unsignedBigInteger('receiver_city_id')->nullable();
            $table->unsignedBigInteger('receiver_postal_code')->nullable();
            $table->string('receiver_address_1');
            $table->string('receiver_address_2')->nullable();
            $table->string('receiver_address_3')->nullable();
            $table->tinyInteger('save_receiver_flg')->default(NOT_SAVE_RECEIVER);

            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('receiver_id')->references('receiver_id')->on('receivers')->onDelete('cascade');
            $table->foreign('receiver_country_id')->references('country_id')->on('countries')->onDelete('cascade');
            $table->foreign('receiver_state_id')->references('state_id')->on('states')->onDelete('cascade');
            $table->foreign('receiver_city_id')->references('city_id')->on('cities')->onDelete('cascade');
            $table->foreign('shipment_service_id')->references('service_id')->on('services')->onDelete('cascade');
            $table->foreign('shipment_branch_id')->references('branch_id')->on('branchs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipments');
    }
};
