<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receivers', function (Blueprint $table) {
            $table->id('receiver_id');
            $table->unsignedBigInteger('user_id');
            $table->string('receiver_company_name');
            $table->string('receiver_contact_name');
            $table->string('receiver_telephone');
            $table->unsignedBigInteger('receiver_country_id');
            $table->unsignedBigInteger('receiver_state_id')->nullable();
            $table->unsignedBigInteger('receiver_city_id')->nullable();
            $table->string('receiver_postal_code')->nullable();
            $table->string('receiver_address_1');
            $table->string('receiver_address_2')->nullable();
            $table->string('receiver_address_3')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('receiver_country_id')->references('country_id')->on('countries')->onDelete('cascade');
            $table->foreign('receiver_state_id')->references('state_id')->on('states')->onDelete('cascade');
            $table->foreign('receiver_city_id')->references('city_id')->on('cities')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receivers');
    }
};
