<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders_pickup', function (Blueprint $table) {
            $table->id('order_pickup_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('user_receiver_id')->nullable();
            $table->unsignedBigInteger('branch_id');
            $table->string('order_pickup_code');
            $table->string('order_pickup_awb');
            $table->string('order_pickup_address');
            $table->string('order_pickup_phone');
            $table->longText('order_pickup_note')->nullable();
            $table->tinyInteger('order_pickup_type');
            $table->dateTime('order_pickup_date_time');
            $table->float('order_pickup_number_packages', 50);
            $table->float('order_pickup_gross_weight', 50);
            $table->longText('order_pickup_image');
            $table->dateTime('order_pickup_date_time_method')->nullable();
            $table->tinyInteger('order_pickup_method')->default(0);
            $table->tinyInteger('order_pickup_status')->default(ORDER_PICKUP_STATUS_WAITING);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('branch_id')->references('branch_id')->on('branchs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders_pickup');
    }
};
