<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_fluctuations', function (Blueprint $table) {
            $table->id('wallet_fluctuation_id');
            $table->unsignedBigInteger('wallet_id');
            $table->string('secure_hash')->default(time());
            $table->unsignedBigInteger('user_id');
            $table->float('amount', 50);
            $table->float('wallet_amount', 50);
            $table->longText('content');
            $table->tinyInteger('kind'); // 0: trừ tiền 1: cộng tiền
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();


            $table->foreign('wallet_id')->references('wallet_id')->on('wallets')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_fluctuations');
    }
};
