<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('items_child_price_list', function (Blueprint $table) {
            $table->id('item_child_price_list_id');
            $table->unsignedBigInteger('price_list_id');
            $table->unsignedBigInteger('child_price_list_id');
            $table->unsignedBigInteger('weight_child_price_list_id');
            $table->unsignedBigInteger('city_id')->nullable();
            $table->float('item_child_price_list_amount', 50);
            $table->float('item_child_price_list_from_weight', 50)->nullable();
            $table->float('item_child_price_list_to_weight', 50)->nullable();
            $table->tinyInteger('item_child_price_list_weight_range_flg')->default(WEIGHT_RANGE_LIMIT);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('price_list_id')->references('price_list_id')->on('price_list')->onDelete('cascade');
            $table->foreign('child_price_list_id')->references('child_price_list_id')->on('child_price_list')->onDelete('cascade');
            $table->foreign('weight_child_price_list_id')->references('weight_child_price_list_id')->on('weights_child_price_list')->onDelete('cascade');
            $table->foreign('city_id')->references('city_id')->on('cities')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items_child_price_list');
    }
};
