<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('weights_child_price_list', function (Blueprint $table) {
            $table->id('weight_child_price_list_id');
            $table->unsignedBigInteger('price_list_id');
            $table->unsignedBigInteger('child_price_list_id');
            $table->unsignedBigInteger('sub_child_price_list_id');
            $table->string('weight_child_price_list_title')->nullable();
            $table->float('child_price_list_from_weight', 50)->nullable();
            $table->float('child_price_list_to_weight', 50)->nullable();
            $table->tinyInteger('weight_range_flg')->default(WEIGHT_RANGE_LIMIT);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('price_list_id')->references('price_list_id')->on('price_list')->onDelete('cascade');
            $table->foreign('child_price_list_id')->references('child_price_list_id')->on('child_price_list')->onDelete('cascade');
            $table->foreign('sub_child_price_list_id')->references('sub_child_price_list_id')->on('sub_child_price_list')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('weights_child_price_list');
    }
};
