<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_child_price_list', function (Blueprint $table) {
            $table->id('sub_child_price_list_id');
            $table->unsignedBigInteger('price_list_id');
            $table->unsignedBigInteger('child_price_list_id');
            $table->unsignedBigInteger('country_id')->nullable();
            $table->unsignedBigInteger('service_id')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('price_list_id')->references('price_list_id')->on('price_list')->onDelete('cascade');
            $table->foreign('child_price_list_id')->references('child_price_list_id')->on('child_price_list')->onDelete('cascade');
            $table->foreign('service_id')->references('service_id')->on('services')->onDelete('cascade');
            $table->foreign('country_id')->references('country_id')->on('countries')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_child_price_list');
    }
};
