<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('child_price_list', function (Blueprint $table) {
            $table->id('child_price_list_id');
            $table->unsignedBigInteger('price_list_id');
            $table->string('child_price_list_title');
            $table->tinyInteger('child_price_list_kind')->default(CHILD_PRICE_LIST_KIND_TRANSPORT_SEA);
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('price_list_id')->references('price_list_id')->on('price_list')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('child_price_list');
    }
};
