<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_users', function (Blueprint $table) {
            $table->id('discount_user_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('service_id');
            $table->float('discount_bigger_1', 50)->default(0);
            $table->float('discount_bigger_2', 50)->default(0);
            $table->float('discount_bigger_3', 50)->default(0);
            $table->float('discount_bigger_4', 50)->default(0);
            $table->float('discount_bigger_5', 50)->default(0);
            $table->string('discount_note')->nullable();
            $table->date('discount_start_date');
            $table->date('discount_end_date');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('service_id')->references('service_id')->on('services')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_users');
    }
};
