<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('states', function (Blueprint $table) {
            $table->id('state_id');
            $table->unsignedBigInteger('country_id');
            $table->string('state_post_code')->nullable();
            $table->string('state_name')->nullable();
            $table->string('state_code');
            $table->string('state_details')->nullable();
            $table->string('state_latitude')->nullable();
            $table->string('state_longitude')->nullable();
            $table->tinyInteger('active_flg')->default(INACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('country_id')->references('country_id')->on('countries')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('states');
    }
};
