<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('surcharge_goods', function (Blueprint $table) {
            $table->id('surcharge_goods_id');
            $table->string('surcharge_goods_name');
            $table->string('surcharge_goods_type');
            $table->float('surcharge_goods_price', 50);
            $table->tinyInteger('active_flg')->default(INACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('surcharge_goods');
    }
};
