<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('code_otps', function (Blueprint $table) {
            $table->id('code_otp_id');
            $table->string('email');
            $table->string('model');
            $table->string('code');
            $table->string('token');
            $table->tinyInteger('kind');
            $table->string('other')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('code_otps');
    }
};
