<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id('user_id');
            $table->string('user_name')->unique();
            $table->string('user_code')->unique();
            $table->string('user_api_key')->unique();
            $table->string('password');
            $table->bigInteger('position_id');
            $table->bigInteger('branch_id');
            $table->string('user_contact_name');
            $table->string('user_phone');
            $table->string('user_address');
            $table->longText('user_signature')->nullable();
            $table->float('user_limit_amount_for_sale', 50)->nullable();
            $table->tinyInteger('active_flg')->default(INACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
