<?php

namespace App\Utils;

use Illuminate\Support\Str;
use App\Models\WeightConversion;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Http;

class TopLogisticsApi
{
    // Đường dẫn API khi chạy trên môi trường production 
    const PRODUCTION_SERVER = 'https://api.toplogistics.com.au/';
    // Đường dẫn API khi chạy trên môi trường testing
    const TESTING_SERVER = 'http://branch.toplogistics.com.au:8189/api/';
    // Mã ứng dụng
    const APP_ID = 'api_test';
    // Mật khẩu ứng dụng
    const API_KEY = '6366b2bb8b8d7407a3d46f6fa79a9af3472e1381442b49e637dfc96a0b0d6808';
    // Đường dẫn API tạo đơn hàng
    const URL_CREATE_SHIPMENT = 'shipment/create';
    const URL_GET_SHIPMENT = 'shipment/get'; 
    const URL_GET_COURIER_LABEL = 'shipment/label';

    /**
     * Generate the sign value for authentication
     * @param array $params
     * @param string $apiKey
     * @return string
     */
    private function generateSign($params, $apiKey)
    {
        unset($params['sign']);

        ksort($params);

        $queryString = '';
        foreach ($params as $key => $value) {
            $queryString .= $key . $value;
        }

        $queryString = $apiKey . $queryString . $apiKey;

        $sign = strtoupper(md5($queryString));

        return $sign;
    }

    /**
     * Create a shipment import excel
     * @param mixed $data
     * @return array
     */
    public function createShipmentImportExcel($data)
    {
        $data['total_weight'] = collect($data['childOrders'])->sum('weight');
        $data['total_height'] = collect($data['childOrders'])->sum('height');
        $data['total_length'] = collect($data['childOrders'])->sum('length');
        $data['total_width'] = collect($data['childOrders'])->sum('width');

        $result = [
            // "test" => true,
            "cref" => $data['referenceNo'] ?? rand(1000000000, 9999999999),
            "type" => 10,
            "packs" => $data['itemCount'],
            "weight" => $data['total_weight'],
            "cbm" => 0.01,
            "currency" => "USD",
            "shipper" => [
                "name" => $data['shipperName'],
                "company" => "",
                "address" => "166 Nguyen Van Cong, Go Vap, Ho Chi Minh",
                "suburb" => "",
                "city" => "",
                "state" => "",
                "country" => "",
                "postcode" => "",
                "phone" => "13000001111",
                "email" => "",
                "cnid" => "string"
            ],
            "consignee" => [
                "name" => $data['recipientName'],
                "company" => "",
                "address" => $data['addressLine1'],
                "suburb" => $data['city'],
                "city" => $data['city'],
                "state" => $data['state'],
                "country" => $data['country'],
                "postcode" => $data['postcode'],
                "phone" => $data['phone'],
                "email" => "",
                "cnid" => "string"
            ],
            "receiver " => [
                "name" => $data['recipientName'],
                "company" => "",
                "address" => $data['addressLine1'],
                "suburb" => $data['city'],
                "city" => $data['city'],
                "state" => $data['state'],
                "country" => $data['country'],
                "postcode" => $data['postcode'],
                "phone" =>  $data['phone'],
                "email" => "test@example.com",
                "cnid" => null
            ],
            "items" => [],
            "note" => "",
            "dg" => 0,
            "label_type" => "AUSPOST",
            "packages" => [],
            "chargecode" => "0439", // SYD: 0439, MEL: 5686
            "amazon_po" => "",
            "amazon_shipment_ids" => "",
            "clear" => "DDU",
            "importer_abn" => "",
            "vendor_id" => "",
            "consignor_tin" => ""
        ];
        foreach ($data['childOrders'] as $key => $package) {
            array_push($result['items'], [
                "name" => $data['description'],
                "name_zh" => "",
                "qty" => $data['itemCount'],
                "price" => $data['unitValue'],
                "hs" => "",
                "sku" => "",
            ]);
        }

        $url = self::TESTING_SERVER . self::URL_CREATE_SHIPMENT;

        $params = [
            'api_id' => self::APP_ID,
            'method' => 'create',
            'data' => json_encode($result),
        ];

        $params['sign'] = $this->generateSign($params, self::API_KEY);

        $response = $this->sendRequest($url, $params);
        return $response;
    }

    /**
     * Create a shipment
     * @param mixed $data
     * @return array
     */
    public function createShipment($data)
    {
        $data['total_weight'] = collect($data['packages'])->sum('weight');
        $data['total_height'] = collect($data['packages'])->sum('height');
        $data['total_length'] = collect($data['packages'])->sum('length');
        $data['total_width'] = collect($data['packages'])->sum('width');
        $data['total_package_weight'] = collect($data['packages'])->sum('package_weight');

        $result = [
            "cref" => $data['shipment_code'],
            "type" => 10,
            "packs" => collect($data['packages'])->count(),
            "weight" => $data['total_weight'],
            "cbm" => 0.01,
            "currency" => "USD",
            "shipper" => [
                "name" => "TEST NAME",
                "company" => "",
                "address" => "166 Nguyen Van Cong, Go Vap, Ho Chi Minh",
                "suburb" => "",
                "city" => "",
                "state" => "",
                "country" => "",
                "postcode" => "",
                "phone" => "13000001111",
                "email" => "",
                "cnid" => "string"
            ],
            "consignee" => [
                "name" => $data['receiver_contact_name'],
                "company" => $data['receiver_company_name'],
                "address" => $data['receiver_address_1'],
                "suburb" => $data['city_code'],
                "city" => $data['city_code'],
                "state" => $data['state_code'],
                "country" => $data['country_code'],
                "postcode" => $data['receiver_postal_code'],
                "phone" => $data['receiver_telephone'],
                "email" => "",
                "cnid" => "string"
            ],
            "items" => [],
            "note" => "",
            "dg" => 0,
            "label_type" => "PDF",
            "packages" => [],
            "chargecode" => "0439",
            "amazon_po" => "",
            "amazon_shipment_ids" => "",
            "clear" => "DDU",
            "importer_abn" => "",
            "vendor_id" => "",
            "consignor_tin" => ""
        ];

        foreach ($data['packages'] as $key => $package) {
            array_push($result['items'], [
                "name" => $data['shipment_goods_name'],
                "name_zh" => "",
                "qty" => collect($data['packages'])->count(),
                "price" => $data['shipment_value'],
                "hs" => "",
                "sku" => "",
            ]);
        }

        $url = self::TESTING_SERVER . self::URL_CREATE_SHIPMENT;

        $params = [
            'api_id' => self::APP_ID,
            'method' => 'create',
            'data' => json_encode($result),
        ];

        $params['sign'] = $this->generateSign($params, self::API_KEY);

        $response = $this->sendRequest($url, $params);

        return $response;
    }

    public function getShipmentDetail($data)
    {
        $url = self::TESTING_SERVER . self::URL_GET_COURIER_LABEL;

        $params = [
            'api_id' => self::APP_ID,
            'method' => 'get',
            'data' => json_encode($data),
        ];

        $params['sign'] = $this->generateSign($params, self::API_KEY);

        $response = $this->sendRequest($url, $params, 'body');

        return $response;
    }

    /**
     * Get courier label
     * @param array $data
     * @return array
     */
    public function getCourierLabel($data)
    {
        $url = self::TESTING_SERVER . self::URL_GET_COURIER_LABEL;

        $params = [
            'api_id' => self::APP_ID,
            'method' => 'label',
            'data' => json_encode($data),
        ];

        $params['sign'] = $this->generateSign($params, self::API_KEY);

        $response = $this->sendRequest($url, $params, 'body');

        return $response;
    }

    /**
     * Send the HTTP request
     * @param string $url
     * @param array $body
     * @return array
     */
    private function sendRequest($url, $body, $type = 'json')
    {
        try {
            $response = Http::asForm()->post($url, $body);

            if ($response->status() == HTTP_OK) {
                if ($type == 'json') {
                    if ($response->json()['status'] == 1) {
                        return [
                            'status' => HTTP_OK,
                            'data' => $response->json()
                        ];
                    } else {
                        return [
                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                            'data' => $response->json()
                        ];
                    }
                }
                return [
                    'status' => HTTP_OK,
                    'data' => $response->{$type}()
                ];
            } else {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'data' => $response->{$type}()
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'data' => [
                    'code' => $th->getCode(),
                    'message' => $th->getMessage()
                ]
            ];
        }
    }
}
