<?php
namespace App\Utils;

use Illuminate\Support\Str;
use App\Models\WeightConversion;
use Illuminate\Support\Facades\Http;

class ShipsaoApi
{
    const url = 'https://api.shipsao.net/api/v2';
    const uid = 'priorityv2';
    const x_api_key = 'fbHcck3G5ePJrMSKsGA2bZ7I1UPArxlV';

    const PATH_CREATE_ORDER = '/order/createOrder';
    const PATH_GET_LABEL = '/order/download';

    public function createOrder($data)
    {
        $data['total_weight'] = collect($data['packages'])->sum('weight');
        $data['total_height'] = collect($data['packages'])->sum('height');
        $data['total_length'] = collect($data['packages'])->sum('length');
        $data['total_width'] = collect($data['packages'])->sum('width');
        $data['total_package_weight'] = collect($data['packages'])->sum('package_weight');

        $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
            ->where('initial_weight', '>=', $data['total_package_weight'])
            ->first();

        if (isset($weight_convert)) {
            $data['total_weight'] = $weight_convert->weight_conversion;
        }

        $result = [
            "uid" => self::uid,
            "FromCountry" => "VN",
            "FromState" => $data->sender_district_name,
            "FromName" => "KANGO",
            "FromCompany" => "KANGO LOG TRANS CO., LTD",
            "FromStreet" => explode(',', $data->sender_address)[0] ?? 'HCM',
            "FromStreet2" => "",
            "FromCity" => $data->sender_city_name,
            "FromPhone" => "13000001111",
            "FromZip" => "700000",
            "ToCountry" => $data->country_code,
            "ToName" => $data->receiver_contact_name,
            "ToCompany" => $data->receiver_company_name,
            "ToStreet" => $data->receiver_address_1,
            "ToStreet2" => "",
            "ToCity" => $data->city_code,
            "ToState" => $data->state_code,
            "ToZip" => $data->receiver_postal_code,
            "ToPhone" => $data->receiver_telephone,
            "description" => $data->shipment_goods_name,
            "Weight" => $data['total_weight'],
            "height" => $data['total_height'],
            "length" => $data['total_length'],
            "width" => $data['total_width'],
            "ref1" => $data->shipment_code,
            "ref2" => $data->shipment_id
        ];

        return $this->_callApiData(self::PATH_CREATE_ORDER, $result);
    }

    public function getLabel($order_id)
    {
        $url = 'https://api.shipsao.net/api/v1/order/download/' . $order_id;
        $x_api_key = self::x_api_key;

        $response = Http::withHeaders([
            'x-api-key' => $x_api_key,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
        ])->get($url);

        $response = $response->body();
        
        return $response;
    }

    public function _callApiData($method, $data)
    {
        try {
            $url = self::url . $method;
            $x_api_key = self::x_api_key;

            $response = Http::withHeaders([
                'x-api-key' => $x_api_key,
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ])->post($url, $data);

            $response = $response->json();
            if ($response['message'] == 'Order created successfully') {
                $response['order']['label_base64'] = $this->getLabel($response['order']['_id']);
                return [
                    'status' => HTTP_OK,
                    'data' => $response['order']
                ];
            }else{
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'data' => $response
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'data' => [
                    'code' => $th->getCode(),
                    'message' => $th->getMessage()
                ]
            ];
        }
    }
}
