<?php
namespace App\Utils;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;

class Seapay
{
    // Đường dẫn API của SePay
    const API_BASE_URL = 'https://my.sepay.vn';
    // ID tài khoản ngân hàng trên SePay
    const BANK_ACCOUNT_ID = 3148;
    // Đường dẫn API lấy thông tin tài khoản ngân hàng
    const URL_BANK_ACCOUNT_DETAIL = '/userapi/bankaccounts/details/' . self::BANK_ACCOUNT_ID;
    // Đường dẫn API lấy danh sách tài khoản ngân hàng
    const URL_BANK_ACCOUNT_LIST = '/userapi/bankaccounts/list';


    /**
     * Lấy thông tin tài khoản ngân hàng
     *
     * @return array
     */
    public static function getBankAccountDetail(): array
    {
        $token = self::getWebhookToken();

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $token,
            'Content-Type' => 'application/json',
        ])->get(self::API_BASE_URL . self::URL_BANK_ACCOUNT_DETAIL);

        return $response->json();
    }

    /**
     * Lấy danh sách tài khoản ngân hàng
     *
     * @return array
     */
    public static function getBankAccountList(): array
    {
        $token = self::getWebhookToken();

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $token,
            'Content-Type' => 'application/json',
        ])->get(self::API_BASE_URL . self::URL_BANK_ACCOUNT_LIST);

        return $response->json();
    }

    /**
     * Lấy token webhook
     *
     * @return string
     */
    public static function getWebhookToken()
    {
        try {
            $path = 'public/config/system-settings.json';
            $settings = json_decode(Storage::get($path), true);
            $index = array_search('setting_key_vnp', array_column($settings, 'name'));
            $token_payment = $settings[$index]['data']['token_payment'];
    
            return $token_payment;
        } catch (\Throwable $th) {
            return env('SEPAY_WEBHOOK_TOKEN');
        }
    }

    /**
     * Lấy thông tin tiền tố giao dịch qua webhook
     *
     * @return string
     */
    public static function getMatchPattern()
    {
        try {
            $path = 'public/config/system-settings.json';
            $settings = json_decode(Storage::get($path), true);
            $index = array_search('setting_key_vnp', array_column($settings, 'name'));
            $match_pattern = $settings[$index]['data']['match_pattern'];
    
            return $match_pattern;
        } catch (\Throwable $th) {
            return env('SEPAY_MATCH_PATTERN');
        }
    }
}
