<?php
namespace App\Utils;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class LabelNzApi
{
    const API_BASE_URL = 'https://omsapi.worldtech.eu/';

    const ROUTE_COUNTRY_INFO = 'API/order/GetCountryInfo'; // post (one), get (all)
    const ROUTE_COUNTRY_INFO_PARAMS = 'API/order/GetCountryInfo?countryCode='; // get (one) vd = US

    const ROUTE_PRODUCT_INFO = 'API/order/GetPbrProductruleInfo';
    const ROUTE_PRODUCT_INFO_PARAMS  = 'API/order/GetPbrProductruleInfo?countryCode='; // get (one) vd = AD

    const ROUTE_BATCH_ADD_POST = 'API/order/BatchAdd'; // post

    const ROUTE_TRACKING_GET = 'api/order/GetTrackingNumber'; //

    const ROUTE_WAY_BILL_GET  = 'api/order/GetWayBill';

    const ROUTE_TRACK_DATA_LIST_BATCH_GET = 'api/order/GetTrackDataListBatch';

    const ROUTE_PRINT_URL  = 'API/PrintUrl';

    const ROUTE_RE_FORECASTCON_POST  = 'api/order/ReForecastcon'; // one
    const ROUTE_RE_FORECASTCON_PARAMS  = 'api/order/ReForecastcon?hawcode='; // one vd: 12515255

    const ROUTE_POST_UPDATE_WEIGHT = 'API/order/UpdateWeight';

    const ROUTE_POST_DELETE_ORDER = 'API/order/DeleteOrder';
    const ROUTE_GET_DELETE_ORDER_PARAMS = 'API/order/DeleteOrder?OrderNumber='; //vd: WT1834412512500000

    const ROUTE_CREATE_BAG_BRAND_POST = 'api/batch/CreateBagBrand';

    const ROUTE_TRACKINGS_REMOTE_POST = 'api/Batch/GetBoxDocumentary';

    protected $apiKey = 'Q05IODUzNDI1NyZYZU8xMnVZZXVGOC9XRXhHVCtBbUFBPT0='; //CNH8534257&XeO12uYeuF8/WExGT+AmAA==


    public function _callApiData($route, $method = 'GET', $sendData = null)
    {

        $method = strtoupper($method);

        try {

            $https = Http::withOptions([
                'base_uri' => self::API_BASE_URL,
                'timeout'  => 90,
            ])->withHeaders([
                'Accept' => 'application/json',
                'Accept-Language' => 'EN',
                'Authorization' => 'Basic ' . $this->apiKey,
            ]);
            $response = null;

            if ($method == 'GET') {
                $response = $https->get($route)->json();
            } else if ($method == 'POST') {
                $response = $https->post($route, $sendData)->json();
            } else if ($method == 'PUT') {
                $response = $https->put($route, $sendData)->json();
            }

            return $response;
        } catch (\Throwable $e) {
            return null;
        }
    }


    function getCountryInfo($country_code = 'US')
    {
        $route = self::ROUTE_COUNTRY_INFO . '?countryCode=' . $country_code;
        $method = 'GET';
        $sendData = [
            "countryCode" => $country_code,
        ];
        $res = $this->_callApiData($route, $method, $sendData);
        if (is_string($res)) {
            $res = json_decode($res, true);
        }
        if ($res['ResultCode'] == '0' || $res['ResultCode'] == '0000') {
            return [
                'status' => true,
                'data' => $res['item']
            ];
        } else {
            return [
                'status' => false,
                'message' => 'Không tìm thấy đất nước'
            ];
        }
    }

    function GetPbrProductruleInfo($country_code = 'US')
    {
        $route = self::ROUTE_PRODUCT_INFO_PARAMS . $country_code;
        $method = 'GET';
        $sendData = [
            "countryCode" => $country_code,
        ];
        $res = $this->_callApiData($route, $method, $sendData);
        if (is_string($res)) {
            $res = json_decode($res, true);
        }
        if ($res['ResultCode'] == '0' || $res['ResultCode'] == '0000') {
            return [
                'status' => true,
                'data' => $res['item']
            ];
        } else {
            return [
                'status' => false,
                'message' => 'Không tìm thấy dịch vụ'
            ];
        }
    }

    function deleteOrder($OrderNumber)
    {
        $route = self::ROUTE_GET_DELETE_ORDER_PARAMS . $OrderNumber;
        $method = 'GET';
        $sendData = [
            "countryCode" => $OrderNumber,
        ];
        $res = $this->_callApiData($route, $method, $sendData);
        if (is_string($res)) {
            $res = json_decode($res, true);
        }
        if ($res['ResultCode'] == '0' || $res['ResultCode'] == '0000') {
            return [
                'status' => true,
                'data' => $res['item']
            ];
        } else {
            return [
                'status' => false,
                'message' => 'Không tìm thấy dịch vụ'
            ];
        }
    }

    function postBatchAdd($data = null)
    {
        $route = self::ROUTE_BATCH_ADD_POST;
        $method = 'POST';
        $sendData = $data;
        if (!$sendData) {
            return [
                'status' => false,
                'message' => 'Dữ liệu trống'
            ];
        }
        $res = $this->_callApiData($route, $method, $sendData);
        if (is_string($res)) {
            $res = json_decode($res, true);
        }
        if ($res['ResultCode'] == '0' || $res['ResultCode'] == '0000') {
            return [
                'status' => true,
                'data' => $res['item']
            ];
        } else {
            return [
                'status' => false,
                'message' => isset($res['item'][0]['Feedback']) ? $res['item'][0]['Feedback'] : 'Khởi tạo thất bại'
            ];
        }
    }




    public function setDataPostAdd($shippingMethodCode,  $countryCode, $shippingFirstName, $shippingAddress, $shippingCity, $data)
    {
        try {
            $result = [
                'OrderNumber' => !empty($data['referenceNo']) ? $data['referenceNo'] : Str::random(40),
                'ShippingMethodCode' => $shippingMethodCode,
                'TrackingNumber' => isset($data['referenceNo']) ? $data['referenceNo'] : "",
                'TransactionNumber' => isset($data['transactionNumber']) ? $data['transactionNumber'] : "",
                'Length' => isset($data['length']) ? intval($data['length']) : 1,
                'Width' => isset($data['width']) ? $data['width'] : 1,
                'Height' => isset($data['height']) ? $data['height'] : 1,
                'PackageNumber' => isset($data['packageNumber']) ? $data['packageNumber'] : 1,
                'Weight' => isset($data['weight']) ? floatval($data['weight']) : 1,
                'ApplicationType' => isset($data['applicationType']) ? $data['applicationType'] : 1,
                'IsReturn' => false,
                'EnableTariffPrepay' => false,
                'InsuranceType' => 0,
                'InsureAmount' => 0.0,
                'SensitiveTypeID' => 0,
                'SourceCode' => 'WT',
                'EORINumber' => isset($data['eoriNumber']) ? $data['eoriNumber'] : 'EORINumber1',
                'VATNumber' => isset($data['vatNumber']) ? $data['vatNumber'] : 'VATNumber2',
                'WarehouseAddressCode' => null,
                "HouseNumber" => isset($data['houseNumber']) ? $data['houseNumber'] : "",
                "ShippingPCCC"  => isset($data['shipmentPccc']) ? $data['shipmentPccc'] : "",
                'IOSSCode' => isset($data['iosscode']) ? $data['iosscode'] : '',
                'ShippingInfo' => [
                    'ShippingTaxId' => isset($data['shippingTaxId']) ? $data['shippingTaxId'] : '',
                    'CountryCode' => $countryCode, // AU
                    'ShippingFirstName' => $shippingFirstName,
                    'ShippingLastName' => isset($data['shippingLastName']) ? $data['shippingLastName'] : '',
                    'ShippingCompany' => isset($data['shippingCompany']) ? $data['shippingCompany'] : '',
                    'ShippingAddress' => $shippingAddress,
                    'ShippingAddress1' => isset($data['shippingAddress1']) ? $data['shippingAddress1'] : '',
                    'ShippingAddress2' => isset($data['shippingAddress2']) ? $data['shippingAddress2'] : '',
                    'ShippingCity' => $shippingCity,
                    'ShippingState' => isset($data['shippingState']) ? $data['shippingState'] : '',
                    'ShippingZip' => isset($data['shippingZip']) ? $data['shippingZip'] : '',
                    'ShippingPhone' => isset($data['shippingPhone']) ? $data['shippingPhone'] : '',
                    'ShippingMobile' => isset($data['shippingMobile']) ? $data['shippingMobile'] : '',
                    'HouseNumber' => isset($data['houseNumber']) ? $data['houseNumber'] : '',
                    'Email' => isset($data['email']) ? $data['email'] : '',
                    'ShippingPCCC' => isset($data['shippingPCCC']) ? $data['shippingPCCC'] : ''
                ],
                'SenderInfo' => [
                    'CountryCode' => isset($data['countryCode']) ? $data['countryCode'] : 'US',
                    'SenderFirstName' => isset($data['senderFirstName']) ? $data['senderFirstName'] : 'KANGO',
                    'SenderLastName' => isset($data['senderLastName']) ? $data['senderLastName'] : '',
                    'SenderCompany' => isset($data['senderCompany']) ? $data['senderCompany'] : 'KANGO LOG TRANS CO., LTD',
                    'SenderAddress' => isset($data['senderAddress']) ? $data['senderAddress'] : 'HCM,VN',
                    'SenderCity' => isset($data['senderCity']) ? $data['senderCity'] : 'HCM',
                    'SenderState' => isset($data['senderState']) ? $data['senderState'] : 'HCM',
                    'SenderZip' => isset($data['senderZip']) ? $data['senderZip'] : '700000',
                    'SenderPhone' => isset($data['senderPhone']) ? $data['senderPhone'] : '13000001111'
                ],
                'ApplicationInfos' => [
                    [
                        'Sku' => isset($data['sku']) ? $data['sku'] : 'Kango2024',
                        'ApplicationName' => isset($data['applicationName']) ? preg_replace('/[^a-zA-Z0-9]/', '', $data['applicationName']) : 'Kango2024',
                        'PickingName' => isset($data['pickingName']) ? $data['pickingName'] : 'Kango2024',
                        'HsCode' => isset($data['HsCode']) ? $data['HsCode'] : '6302999090', // 6302999090 rand(1000000000, 9999999999)
                        'Qty' => isset($data['qty']) ? $data['qty'] : 1,
                        'UnitPrice' => isset($data['unitPrice']) ? $data['unitPrice'] : 200,
                        'UnitWeight' => isset($data['unitWeight']) ? $data['unitWeight'] : 1.222,
                        'ProductUrl' => isset($data['productUrl']) ? $data['productUrl'] : '',
                        'Order_cartons' => isset($data['order_cartons']) ? $data['order_cartons'] : null,
                        'extraservices' => isset($data['extraservices']) ? $data['extraservices'] : null,
                        'InvoiceRemarke' => isset($data['invoiceRemarke']) ? $data['invoiceRemarke'] : '1221',
                        'CurrencyCode' => isset($data['currencyCode']) ? $data['currencyCode'] : 'USD',
                        'additional_services' => isset($data['additional_services']) ? $data['additional_services'] : null
                    ]
                ],
                'AdditionalServices' => isset($data['additionalServices']) ? $data['additionalServices'] : '',
                'Extraservices' => isset($data['extraservices']) ? $data['extraservices'] : null
            ];
            if (isset($data['childOrders'])) {
                $childs = [];
                foreach ($data['childOrders'] as $key => $value) {
                    $child = [
                        'BoxNumber' => "" . ($key + 1),
                        'Length' => (int) $value['length'],
                        'Width' => (int) $value['width'],
                        'Height' => (int) $value['height'],
                        'BoxWeight' => (float) $value['weight'],
                    ];
                    array_push($childs, $child);
                }
                $result['ChildOrders'] = $childs;
            }
            return $result;
        } catch (\Throwable $th) {
            return null;
        }
    }


    public function handleCreateAUK($data)
    {
        try {
            $sendData = [
                "merchantId" => isset($data['merchantId']) ? $data['merchantId'] : '990', // 
                "lineCode" => $data['lineCode'], // Đường vận chuyển (chọn 1 trong "APD/AAI/ASI/NAI")
                "orderNo" => isset($data['orderNo']) ? $data['orderNo'] : rand(10000000000, 99999999999), // Mã số (VD:"20240718004") 
                "destination" => $data['destination'], // Điểm đến (chọn 1 trong "Sydney/Melbourne")
                "consigneeName" => $data['consigneeName'], // Tên người nhận (VD:"Malachi")
                "consigneeAdress1" => $data['consigneeAdress1'], // Địa chỉ người nhận (VD:"xing xing 666 no.")
                "consigneeAdress2" => isset($data['consigneeAdress2']) ? $data['consigneeAdress2'] : "", //"",
                "consigneeCity" => $data['consigneeCity'], //Thành phố người nhận (VD:"ACTON"),
                "consigneeState" => $data['consigneeState'], //Khu vực người nhận (VD:"ACT"),
                "consigneePostcode" => $data['consigneePostcode'], // Mã bưu điện (VD:"2601"),
                "consigneeCountryCode" => $data['consigneeCountryCode'], //"AU",
                "consigneePhone" => $data['consigneePhone'], //"03 9322 0665",
                "consignorName" => $data['consignorName'], // Tên người gửi (VD:"liming"),
                "consignorAddress1" => $data['consignorAddress1'], //"sjz",
                "consignorAddress2" => isset($data['consignorAddress2']) ?  $data['consignorAddress2'] : '', //"",
                "consignorCity" => $data['consignorCity'], //"A city",
                "consignorState" => $data['consignorState'], //"xinhua",
                "consignorPostcode" => $data['consignorPostcode'], //"052160",
                "consignorCountryCode" => $data['consignorCountryCode'], //"CN",
                "consignorPhone" => $data['consignorPhone'], //"19955555555",
                "parcelQty" => $data['parcelQty'], // Số lượng bưu kiện (VD:"1"),
                "parcelVolume" => $data['parcelVolume'], // Thể tích=d*r*h , (VD:"0.25")
                "parcelWeight" => $data['parcelWeight'], // Trọng lượng, (VD:"8.8")
                "goodsDescription" => $data['goodsDescription'], //"goodsDescription",
                "goodValue" => $data['goodValue'], // Giá trị kiện hàng (VD:"17.379"),
                "length" => $data['length'], //"37",
                "width" => $data['width'], //"33",
                "height" => $data['height'], //"33"
            ];

            $route = "https://auk.global-parcel-hub.com/prod-api/api/auOrder/create";

            $response = Http::withHeaders([
                'Accept' => 'application/json',
            ])->post($route, $sendData)->json();

            $result = $response;
            // $result = json_decode($response, true);

            return [
                'status' => $result['code'],
                'message' => $result['msg'],
                'data' => isset($result['data']) ? $result['data'] : null,
            ];
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_BAD_REQUEST,
                'message' => "Xảy ra lỗi khi gọi API",
                'error' => $th->getMessage(),
            ];
        }
    }
}
