<?php

use Carbon\Carbon;
use App\Models\City;
use App\Models\Town;
use App\Models\User;
use App\Models\Debit;
use App\Models\State;
use App\Models\Branch;
use App\Models\CheckedPaymentCash;
use App\Models\Wallet;
use App\Models\Country;
use App\Models\Invoice;
use App\Models\Package;
use App\Models\SaleKpi;
use App\Models\Service;
use App\Models\SaleTeam;
use App\Models\Shipment;
use App\Utils\AfterShip;
use App\Models\DebitItem;
use App\Models\PackageSg;
use App\Models\PriceList;
use App\Models\MenuByPosition;
use App\Models\SaleMember;
use App\Models\SmsHistory;
use App\Models\SaleLinkFwd;
use Illuminate\Support\Str;
use App\Models\OperatingCost;
use App\Models\PriceListUser;
use App\Models\PriceListZone;
use Illuminate\Routing\Route;
use App\Models\SurchargeGoods;
use App\Models\FwdCostByService;
use App\Models\SetAmountShipment;
use App\Models\SubChildPriceList;
use App\Models\WalletFluctuation;
use App\Models\AccountActivityLog;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
use App\Models\ShipmentOperatingCost;
use Illuminate\Support\Facades\Storage;
use App\Models\LabelNz as ModelsLabelNz;
use App\Models\Statement;
use Illuminate\Support\Facades\Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

function viewError404($show = false, $notifi = ["icon" => "warning", "text" => "Bạn không đủ quyền truy cập"])
{
    if ($show) {
        Session::flash($notifi['icon'], $notifi['text']);
    }
    return view('template.errors.404');
}

function viewBaoTri()
{
    return view('template.errors.bao-tri');
}

function viewWarning($status, $message)
{
    return view('template.errors.warning', compact('status', 'message'));
}

function onCreateAccountActivityLogs($action, $details = null, $data = null)
{
    try {
        $user = request()->user();

        $history = AccountActivityLog::create([
            'user_id' => $user['user_id'],
            'action' => $action,
            'details' => $details,
            'ip_address' => request()->ip(),
            'performed_at' => Carbon::now()->setTimezone('Asia/Ho_Chi_Minh'),
        ]);
        if (isset($data)) {
            $filePath = 'public/activity_logs/activity_' . ($history['id'] ?? time()) . '.json';
            Storage::disk('local')->put($filePath, json_encode($data, JSON_PRETTY_PRINT));

            $history->path = $filePath;
            $history->save();
        }
    } catch (\Throwable $th) {
        //throw $th;
    }
}
function onDeleteActivityLogs()
{
    try {
        $daysAgo = Carbon::now()->subDays(3)->setTimezone('Asia/Ho_Chi_Minh');

        $data = AccountActivityLog::where('created_at', '<', $daysAgo)->get();
        foreach ($data as $key => $value) {
            if (!empty($value['path']) && Storage::exists($value['path'])) {
                Storage::delete($value['path']);
            }
            $value->delete();
        }
    } catch (\Throwable $th) {
    }
}

function setSlug($text)
{
    if (is_string($text)) {
        return Str::slug($text, '-');
    } else {
        return '' . time();
    }
};
function customTextAvatar($string)
{
    try {
        $arr_text = explode(" ", trim($string));

        $count = count($arr_text);
        if ($count > 1) {
            $first_txt = $arr_text[$count - 1][0];
            $last_txt = isset($arr_text[0][0]) ? $arr_text[0][0] : '';
            return $last_txt . $first_txt;
        } else {
            return $last_txt = isset($arr_text[0][0]) ? $arr_text[0][0] : '';
        }
    } catch (\Throwable $th) {
        return 'KG';
    }
}

function convertSearchString($string)
{
    try {
        return '%' . str_replace(' ', '%', $string) . '%';
    } catch (\Throwable $th) {
        return '%%';
    }
}

function formatFullDate($date)
{
    return Carbon::parse($date)->setTimezone('Asia/Ho_Chi_Minh')->format('d-m-Y H:i:s');
}

function formatDate($date)
{
    return Carbon::parse($date)->setTimezone('Asia/Ho_Chi_Minh')->format('d-m-Y');
}

function formatDate2($date)
{
    return Carbon::parse($date)->setTimezone('Asia/Ho_Chi_Minh')->format('d/m/Y');
}
function convertTimeDiffrent($time)
{
    return Carbon::parse($time)->diffForHumans();
}

function formatDateDiffForHumans($date)
{
    return Carbon::parse($date)->setTimezone('Asia/Ho_Chi_Minh')->diffForHumans();
}

function formatNumber($number)
{
    $number = floatval($number);
    $numberAsString = strval($number);
    $count = 0;
    if (strpos($numberAsString, '.') !== false) {
        $count = strlen(substr($numberAsString, strpos($numberAsString, '.') + 1));
    }
    return number_format($number, $count, '.', ',');
}

function showReturnNotFound($name = 'Đối tượng')
{
    return response()->json([
        'status' => HTTP_NOT_FOUND,
        'message' => $name . ' này không tồn tại'
    ]);
}

function showMessageError()
{
    return response()->json([
        'status' => HTTP_INTERNAL_SERVER_ERROR,
        'message' => [
            'title' => 'Thất bại!',
            'text' => 'Đã xảy ra lỗi trong quá trình dữ lý dữ liệu.',
            'icon' => 'error',
        ]
    ], HTTP_INTERNAL_SERVER_ERROR);
}


function returnFalseWithResponse($status = null, $text = null, $title = null, $icon = null)
{
    return [
        'status' => false,
        'res' => response()->json([
            'status' => empty($status) ? HTTP_BAD_REQUEST : $status,
            'message' => [
                'icon' => empty($icon) ? 'error' : $icon,
                'title' => empty($title) ? 'Thông báo' : $title,
                'text' => empty($text) ? 'Xảy ra lỗi dưới serve' : $text
            ]
        ])
    ];
}
function returnResponse($status = null, $text = null, $title = null, $icon = null, $others = [])
{
    $response = [
        'status' => $status ?? HTTP_BAD_REQUEST,
        'message' => [
            'icon' => $icon ?? 'error',
            'title' => $title ?? 'Thông báo',
            'text' => $text ?? 'Xảy ra lỗi dưới serve',
        ]
    ];

    foreach ($others as $key => $value) {
        $response[$key] = $value;
    }

    return response()->json($response);
}


function generatorQRCode($content, $type, $size = 120)
{
    $qrCodes = [];
    $qrCodes['simple'] = QrCode::size($size)->generate($content);
    $qrCodes['changeColor'] = QrCode::size($size)->color(255, 0, 0)->generate($content);
    $qrCodes['changeBgColor'] = QrCode::size($size)->backgroundColor(255, 0, 0)->generate($content);

    $qrCodes['styleDot'] = QrCode::size($size)->style('dot')->generate($content);
    $qrCodes['styleSquare'] = QrCode::size($size)->style('square')->generate($content);
    $qrCodes['styleRound'] = QrCode::size($size)->style('round')->generate($content);

    // $qrCodes['withImage'] = QrCode::size($size)->format('png')->merge('/public/assets/images/logo-kango.png', .4)->generate($content);
    return $qrCodes[$type];
}

function convertImagesBase64ToDirectory($images = [], $public_path = '', $imageName = null, $extention = 'jpg')
{
    try {
        $directoryToCheck = public_path($public_path);
        if (!File::exists($directoryToCheck)) {
            File::makeDirectory($directoryToCheck, $mode = 0777, true, true);
        }
        $images = is_string($images) ? json_decode($images) : $images;
        foreach ($images as $key => $image) {
            if (strlen($image) > 250) {
                $type_image = strpos($image, "data:image/png") !== false ? 'png' : $extention;
                $imageName = isset($imageName) ? ($imageName . '-' . $key . '-' . time()) : Str::random(50);
                $imageName = "$imageName.$type_image";
                $location = public_path("$public_path/$imageName");
                file_put_contents($location, base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $image)));
                $images[$key] = "$public_path/$imageName";
            } else {
                $images[$key] = $image;
            }
        }
        return $images;
    } catch (\Throwable $th) {
        return [];
    }
}

function onConvertStrArrImage($str_imgages, $have_asset = true)
{
    try {
        // Giải mã JSON từ chuỗi đầu vào
        $images = json_decode($str_imgages, true);
        $new_images = [];

        // Kiểm tra nếu `json_decode` trả về `null` thì `$str_imgages` không phải là JSON
        if (is_null($images)) {
            if (!empty($str_imgages)) {
                // Nếu không phải JSON, coi `$str_imgages` là một chuỗi đường dẫn đơn
                array_push($new_images, $have_asset ? asset($str_imgages) : $str_imgages);
            }
        } else {
            // Nếu là mảng, duyệt qua từng phần tử
            foreach ($images as $value) {
                array_push($new_images, $have_asset ? asset($value) : $value);
            }
        }
        return $new_images;
    } catch (\Throwable $th) {
        // Xử lý ngoại lệ nếu có lỗi
        return [];
    }
}

function address($city = null, $district = null)
{
    $cities = collect(config('constans.area'))->pluck('name')->toArray();
    $areas = [
        'cities' => $cities,
        'districts' => [],
        'wards' => [],
    ];
    if (isset($city) || $city !== "") {
        $areas['districts'] = collect(config('constans.area.' . $city . '.districts'))->pluck('name')->toArray();
    }
    if ((isset($city) || $city !== "") && (isset($district) || $district !== "")) {
        $areas['wards'] = collect(config('constans.area.' . $city . '.districts.' . $district . '.wards'))->pluck('name')->toArray();
    }
    return $areas;
}

function actionWallet($data, $user_id = null) // Cập nhật ví tiền và tạo biến động số dư
{
    // Data truyền vào bao gồm: 
    // kind: kiểu PLUS/MINUS, 
    // user_id: mã tài khoản, 
    // amount: số tiền mà cần cộng/trừ
    // content: nội dung chuyển khoản (không bất buộc
    try {
        // $user_id = isset($user_id) ? $user_id : auth()->id();
        $user = User::with(['position'])->findOrFail($data['user_id']);
        $wallet = Wallet::where('user_id', $data['user_id'])->first();
        if (!$wallet) {
            $wallet = Wallet::create([
                'user_id' => $data['user_id'],
                'amount' => 0,
            ]);
        }


        if (isset($data['kind'])) {
            $final_amount = $wallet->amount;
            switch ($data['kind']) {
                case MINUS:
                    $final_amount = $wallet->amount - $data['amount'];

                    if ($final_amount < 0) {
                        if (($user['position']['limit_amount_flg'] == NO_LIMIT) || ($user['position']['limit_amount_flg'] == LIMITED && $data['amount'] < ($user['user_limit_amount_for_sale'] - $user['user_remaining_limit']))) {
                            $user->update(["user_remaining_limit" => ($user->user_remaining_limit += $data['amount'])]);
                            $note = "Số tiền trong ví không đủ để thực hiện giao dịch, hệ thống sẽ ghi nợ đơn này của bạn. Vui lòng thanh toán đúng thời hạn!";
                            $final_amount = $wallet->amount;
                        } else if ($user['position']['limit_amount_flg'] == LIMITED && $data['amount'] > ($user['user_limit_amount_for_sale'] - $user['user_remaining_limit'])) {
                            return [
                                "status" => HTTP_INTERNAL_SERVER_ERROR,
                                "message" => "Số tiền trong tài khoản không đủ để trừ"
                            ];
                        } else {
                            return [
                                "status" => HTTP_INTERNAL_SERVER_ERROR,
                                "message" => "Số tiền trong tài khoản không đủ để trừ"
                            ];
                        }
                    }
                    $note = isset($data['content']) ? $data['content'] : "Trừ tiền vào tài khoản";
                    break;

                case PLUS:
                    $final_amount = $wallet->amount + $data['amount'];
                    $note = isset($data['content']) ? $data['content'] : "Cộng tiền vào tài khoản";
                    break;

                default:
                    return [
                        "status" => HTTP_NOT_FOUND,
                        "message" => "Không xác thực thao tác với ví tiền"
                    ];
            }

            $wf = [
                "wallet_id" => $wallet->wallet_id,
                "secure_hash" => "WF" . Carbon::now()->format('YmdHisv'),
                "user_id" => $data['user_id'],
                "amount" => $data['amount'],
                "wallet_amount" => $final_amount,
                "content" => $note,
                "kind" => $data['kind'],
            ];
            WalletFluctuation::create($wf);
            $wallet->update(["amount" => $final_amount]);
            return [
                "status" => HTTP_OK,
                "message" => "Thao tác thành công"
            ];
        } else {
            return [
                "status" => HTTP_NOT_FOUND,
                "message" => "Lỗi kiểu không tồn tại"
            ];
        }
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_INTERNAL_SERVER_ERROR,
            'message' => "Xảy ra lỗi không xác đinh!",
            'errors' => $th->getMessage(),
        ];
    }
}

function updateUserRemainingLimit($user_id, $amount, $other_content = [])
{
    try {

        $wallet = Wallet::where('user_id', $user_id)->first();
        $user = User::find($user_id);
        if ($wallet && $wallet->amount >= $amount) {
            $data = [
                'kind' => MINUS,
                'user_id' => $user_id,
                'amount' => $amount,
                'content' => isset($other_content['content1']) ? $other_content['content1'] : null,
            ];
            $result_w = actionWallet($data);
            if ($result_w['status'] != HTTP_OK) {
                return returnResponse(HTTP_BAD_REQUEST, $result_w['message']);
            }
            $remaining_limit = $user->user_remaining_limit - $amount;
            $user->update(['user_remaining_limit' => $remaining_limit > 0 ? $remaining_limit : 0]);
            if ($remaining_limit < 0) {
                $data = [
                    'kind' => PLUS,
                    'user_id' => $user_id,
                    'amount' => abs($remaining_limit),
                    'content' => isset($other_content['content2']) ? $other_content['content2'] : null,
                ];
                actionWallet($data);
            }
            return [
                'status' => HTTP_OK,
                'message' => 'Công nhật số nợ thành công'
            ];
        } else {
            return [
                'status' => HTTP_NOT_FOUND,
                'message' => 'Số tiền của bạn không đủ để thanh toán'
            ];
        }
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_NOT_FOUND,
            'message' => 'Lỗi khi cố cập nhật công nợ của tài khoản'
        ];
    }
}

function updateUserRemainingLimit2($user_id, $amount, $kind, $note = '')
{
    try {
        $user = User::find($user_id);
        if ($kind == PLUS) {
            $remaining_limit = $user->user_remaining_limit + $amount;
        } else {
            $remaining_limit = $user->user_remaining_limit - $amount;
        }
        $user = User::find($user_id)->update(['user_remaining_limit' => $remaining_limit]);
        saveHistoryDebit(
            'history_debit',
            $user_id,
            $user_id,
            $amount,
            $kind,
            $note
        );
        return [
            'status' => HTTP_OK,
            'message' => '',
        ];
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_NOT_FOUND,
            'message' => 'Lỗi khi cố cập nhật công nợ của tài khoản'
        ];
    }
}


function formatWeightPackage($number, $kind = null)
{
    try {
        if (isset($kind) && $kind == IS_EPACKET) {
            return ceil($number * 10) / 10;
        } else {
            if ($number < 21) {
                return ceil($number * 2) / 2;
            } else {
                return ceil($number);
            }
        }
    } catch (\Throwable $th) {
        return 0;
    }
}

function formatNumberCeil($number, $total_weight = 0, $kind = NO_PROMOTION)
{
    try {
        if ($kind != IS_EPACKET) {
            if ($total_weight < 21) {
                return ceil($number * 2) / 2;
            } else {
                return ceil($number);
            }
        } else {
            return ceil($number * 10) / 10;
        }
    } catch (\Throwable $th) {
        return 0;
    }
}

function initializationShipmentCode()
{
    $last_shipment = Shipment::latest('shipment_id')->first();
    if ($last_shipment) {
        preg_match('/\d+$/', $last_shipment->shipment_code, $matches);
        $last_numeric_part = $matches[0] ?? '0';
        $new_numeric_part = (int) $last_numeric_part + 1;
        return str_pad($new_numeric_part, 10, '0', STR_PAD_LEFT);
    } else {
        return '2024010900';
    }

    // $last_shipment = Shipment::latest('shipment_id')->first();
    // if ($last_shipment && isset($last_shipment->shipment_code)) {
    //     return $last_shipment->shipment_code + 1;
    // } else {
    //     return '2024010900';
    // }
}

function initializationPackageCode()
{
    $last_package = Package::latest('package_id')->first();
    if ($last_package) {
        $last_package_code_numeric = substr($last_package->package_code, 3);
        $new_package_code_numeric = (int) $last_package_code_numeric + 1;
        return "PKG" . str_pad($new_package_code_numeric, 10, '0', STR_PAD_LEFT);
    } else {
        return "PKG" . '0000000001';
    }
}

function initializationHawbCodeForPackage($count)
{
    $last_package = Package::latest('package_id')->first();
    if ($last_package && isset($last_package->new_package_hawb_code)) {
        return $last_package->new_package_hawb_code + 1;
    } else {
        return '2024010900';
    }
    // if ($last_package) {
    //     $last_package_hawb_code = $last_package->package_hawb_code;
    //     $new_package_hawb_code = (int) $last_package_hawb_code + ($count * 2);
    //     return str_pad($new_package_hawb_code, 10, '0', STR_PAD_LEFT);
    // } else {
    //     return '0000000002';
    // }
}

function initializationInvoiceCode()
{
    $last_invoice = Invoice::latest('invoice_id')->first();
    if ($last_invoice) {
        $last_invoice_code_numeric = substr($last_invoice->invoice_code, 3);
        $new_invoice_code_numeric = (int) $last_invoice_code_numeric + 1;
        return "INV" . str_pad($new_invoice_code_numeric, 10, '0', STR_PAD_LEFT);
    } else {
        return "INV" . '0000000001';
    }
}

function initializationCode($table, $name_col, $first_name, $count = 10)
{
    $tables = DB::table($table)->latest($name_col)->first();
    $tables = (array) $tables;
    if ($tables) {
        $tables_code_numeric = $tables[$name_col];
        $new_tables_numeric = preg_replace('/\D/', '', $tables_code_numeric) + 1;
        return $first_name . str_pad($new_tables_numeric, $count, '0', STR_PAD_LEFT);
    } else {
        $number_str = "";
        for ($i = 1; $i < $count; $i++) {
            $number_str = $number_str . "0";
        }
        return $first_name . $number_str . '1';
    }
}

function initializationCode2($table, $name_col, $first_name, $count = 10)
{
    $tables = DB::table($table)->latest($name_col)->first();
    $tables = (array) $tables;
    if ($tables) {
        $tables_code_numeric = $tables[$name_col];
        $new_tables_numeric = (int) $tables_code_numeric + 1 + 20000;
        return $first_name . str_pad($new_tables_numeric, $count, '0', STR_PAD_LEFT);
    } else {
        return $first_name . '0000000001';
    }
}

function onSaveAmountShipment($shipment_id)
{
    // DB::beginTransaction();
    try {
        $now = Carbon::now()->format('Y-m-d');
        $shipment = Shipment::find($shipment_id);
        $old_data = Shipment::find($shipment_id);
        $country_id = $shipment['receiver_country_id'];
        $state_id = $shipment['receiver_state_id'];
        $city_id = $shipment['receiver_city_id'];
        $branch_id = $shipment['shipment_branch_id'];
        $packages_weight = Package::isShow()
            ->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)
            ->where('shipment_id', $shipment_id)->sum('package_charged_weight');

        $user = User::findOrFail($shipment['user_id']);
        $service_applicable_weight = $shipment['service']['service_applicable_weight'];

        $shipment_amount_transport = 0;
        $shipment_amount_service = 0;

        $service = Service::findOrFail($shipment['shipment_service_id']);
        $branch = Branch::findOrFail($shipment['shipment_branch_id']);

        if (
            onCheckPositionAccount(SETTING_SALE_ACCOUNT, $user['position_id']) ||
            onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user['position_id'])
        ) {
            $child_price_list_kind = $service['transport_type'] == SERVICE_TRANSPORT_SEA ? CHILD_PRICE_LIST_KIND_TRANSPORT_SEA : CHILD_PRICE_LIST_KIND_TRANSPORT_AIR;
            $price_list_transport = PriceList::where('price_list_tranport_type', PRICE_LIST_TYPE_DELIVERY)
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('child_price_list', 'price_list.price_list_id', '=', 'child_price_list.price_list_id')
                ->leftJoin('sub_child_price_list', 'child_price_list.child_price_list_id', '=', 'sub_child_price_list.child_price_list_id')
                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                ->where('child_price_list.child_price_list_kind', $child_price_list_kind)
                ->where('sub_child_price_list.country_id', $shipment['receiver_country_id']);

            if (isset($shipment['receiver_city_id'])) {
                $price_list_transport = $price_list_transport->where('items_child_price_list.city_id', $shipment['receiver_city_id']);
            }
            $price_list_transport = $price_list_transport->where(function ($query) use ($packages_weight) {
                $query->where('weights_child_price_list.child_price_list_from_weight', '<=', $packages_weight)
                    ->where('weights_child_price_list.child_price_list_to_weight', '>=', $packages_weight);
            })
                ->where(function ($query) use ($now) {
                    $query->whereNull('price_list_start_date')
                        ->whereNull('price_list_end_date')
                        ->orWhere(function ($query) use ($now) {
                            $query->where('price_list_start_date', '<=', $now)
                                ->where('price_list_end_date', '>=', $now);
                        });
                })
                ->select('items_child_price_list.item_child_price_list_amount')->first();

            if (isset($price_list_transport)) {
                $shipment_amount_transport = $price_list_transport['item_child_price_list_amount'];
            }

            // $user_child_price_list = PriceListUser::where('user_id', $shipment->user_id)->pluck('child_price_list_id')->toArray();
            $price_list_service = PriceList::where('price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('child_price_list', 'price_list.price_list_id', '=', 'child_price_list.price_list_id')
                ->leftJoin('sub_child_price_list', 'child_price_list.child_price_list_id', '=', 'sub_child_price_list.child_price_list_id')
                ->where('child_price_list.branch_id', $branch_id);

            // set trường hợp nếu user là sale thì mới kiểm tra
            // if (onCheckPositionAccount(SETTING_SALE_ACCOUNT, $user['position_id']) || onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user['position_id'])) {
            //     $price_list_service = $price_list_service
            //         ->whereIn('child_price_list.child_price_list_id', $user_child_price_list)
            //         ->where('child_price_list.price_list_id', $user['user_price_list_main_type']);
            // }
            // $price_list_service = $price_list_service
            //     ->whereIn('child_price_list.child_price_list_id', $user_child_price_list)
            //     ->where('child_price_list.price_list_id', $user['user_price_list_main_type']);

            $date_confirm = $shipment['completed_date'] ?? $shipment['created_at'];
            $shipment_created_at = Carbon::parse($date_confirm)->format('Y-m-d');
            $price_list_service = $price_list_service->where('child_price_list.position_id', $user['position_id'])
                ->where('child_price_list.user_type', $user['user_price_list_main_type'])
                ->where(function ($query) use ($shipment_created_at) {
                    $query->whereNull('price_list_start_date')
                        ->whereNull('price_list_end_date')
                        ->orWhere(function ($query) use ($shipment_created_at) {
                            $query->where('price_list_start_date', '<=', $shipment_created_at)
                                ->where('price_list_end_date', '>=', $shipment_created_at);
                        });
                });

            $price_list_service = $price_list_service
                ->where('child_price_list.child_price_list_kind', CHILD_PRICE_LIST_KIND_TRANSPORT_OTHER)
                ->where('sub_child_price_list.service_id', $shipment['shipment_service_id'])
                ->select('sub_child_price_list.*')
                ->first();
            if (isset($price_list_service)) {
                $sub_child_price_list_type = $price_list_service['sub_child_price_list_type'];

                $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                    ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                    ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                    ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id');

                switch ($sub_child_price_list_type) {
                    case SUB_CHILD_PRICE_LIST_TYPE_COUNTRY:
                        $sub_child_price_list->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->where('weight_child_price_list_area.country_id', $country_id);

                        $exists = $sub_child_price_list->exists();

                        if (!$exists) {
                            $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                                ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                                ->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                                ->where(function ($query) use ($packages_weight) {
                                    $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                        ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                        ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                                })
                                ->whereNull('weight_child_price_list_area.country_id');
                        }

                        $sub_child_price_list->select('items_child_price_list.*');
                        break;

                    case SUB_CHILD_PRICE_LIST_TYPE_STATE:
                        $sub_child_price_list->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->where('weight_child_price_list_area.state_id', $state_id);

                        $exists = $sub_child_price_list->exists();

                        if (!$exists) {
                            $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                                ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                                ->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                                ->where(function ($query) use ($packages_weight) {
                                    $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                        ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                        ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                                })
                                ->whereNull('weight_child_price_list_area.state_id');
                        }

                        $sub_child_price_list->select('items_child_price_list.*');
                        break;

                    case SUB_CHILD_PRICE_LIST_TYPE_CITY:
                        $sub_child_price_list->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->where('weight_child_price_list_area.city_id', $city_id);

                        $exists = $sub_child_price_list->exists();

                        if (!$exists) {
                            $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                                ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                                ->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                                ->where(function ($query) use ($packages_weight) {
                                    $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                        ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                        ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                                })
                                ->whereNull('weight_child_price_list_area.city_id');
                        }

                        $sub_child_price_list->select('items_child_price_list.*');
                        break;

                    case SUB_CHILD_PRICE_LIST_TYPE_POST_CODE:
                        $town_id = Town::where('town_postal_code', $shipment['receiver_postal_code'])
                            ->where('country_id', $shipment['receiver_country_id'])
                            ->where('service_id', $shipment['shipment_service_id'])
                            ->value('town_id');

                        $sub_child_price_list->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })->where('weight_child_price_list_area.town_id', $town_id);

                        $exists = $sub_child_price_list->exists();

                        if (!$exists) {
                            $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                                ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                                ->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                                ->where(function ($query) use ($packages_weight) {
                                    $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                        ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                        ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                                })->whereNull('weight_child_price_list_area.town_id');
                        }

                        $sub_child_price_list->select('items_child_price_list.*');
                        break;

                    default:

                        $sub_child_price_list->where(function ($query) use ($packages_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                            ->select('items_child_price_list.*');
                        break;
                }
                $sub_child_price_list = $sub_child_price_list->first();
                if (!isset($sub_child_price_list)) {
                    return [
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => [
                            'title' => 'Thất bại!',
                            'text' => getTextNotFoundService($shipment, $packages_weight, $service, $branch),
                            'icon' => 'error',
                        ]
                    ];
                }

                // Nếu có bảng giá dịch vụ thì tính giá dịch vụ
                if (isset($sub_child_price_list['item_child_price_list_amount'])) {
                    // Nếu trọng lượng lớn hơn 21kg thì giá dịch vụ = trọng lượng * giá dịch vụ, ngược lại giá dịch vụ = giá dịch vụ
                    $shipment_amount_service = $packages_weight >= $service_applicable_weight ? $packages_weight * $sub_child_price_list['item_child_price_list_amount'] : $sub_child_price_list['item_child_price_list_amount'];
                    // $shipment_amount_service = $packages_weight >= 21 ? $packages_weight * $sub_child_price_list['item_child_price_list_amount'] : $sub_child_price_list['item_child_price_list_amount'];
                }
            } else {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => getTextNotFoundService($shipment, $packages_weight, $service, $branch),
                        'icon' => 'error',
                    ]
                ];
            }
        }

        $shipment->shipment_amount_transport = $shipment_amount_transport;
        $shipment->shipment_amount_service = $shipment_amount_service;

        $set_shipment_amount_original = SetAmountShipment::isShow()
            ->where('shipment_code', $shipment->shipment_code)
            ->orderBy('created_at', 'desc')->first();
        if ($set_shipment_amount_original && $packages_weight >= 21) {
            // Giá mới 
            $new_amount_service = $set_shipment_amount_original['set_amount'] * $packages_weight;

            $shipment->shipment_amount_service = $new_amount_service;
            $shipment->shipment_amount_original = $new_amount_service + $shipment_amount_transport;

            $set_shipment_amount_original->old_amount = $shipment_amount_service / $packages_weight;
            $set_shipment_amount_original->save();
        } else {
            $shipment->shipment_amount_original = $shipment_amount_transport + $shipment_amount_service;
        }

        $shipment_amount_discount = onGetAmountDiscount($shipment->shipment_service_id, $shipment->user_id, $packages_weight);
        $shipment->shipment_amount_discount = $shipment_amount_discount;
        $shipment->save();

        // DB::commit();
        // Lịch sử hoạt động tài khoản
        $data_logs = [
            'old_data' => $old_data,
            'new_data' => $shipment
        ];
        onCreateAccountActivityLogs('Tạo/Cập nhật shipment', 'Tính tiền lô hàng ' . $old_data['shipment_code'], $data_logs);
        return [
            'status' => HTTP_OK,
            'shipment_amount_transport' => $shipment_amount_transport,
            'shipment_amount_service' => $shipment_amount_service,
        ];
    } catch (\Throwable $th) {
        // DB::rollBack();
        return [
            'status' => HTTP_INTERNAL_SERVER_ERROR,
            'shipment_amount_transport' => 0,
            'shipment_amount_service' => 0,
        ];
    }
}

function getTextNotFoundService($shipment, $packages_weight, $service, $branch)
{
    try {
        $text_service = 'Không tìm thấy dịch vụ ' . $service['service_name'];
        $text_branch = 'thuộc chi nhánh ' . $branch['branch_name'];
        $text_packages_weight = 'với tổng số ký ' . $packages_weight . 'kg';
        $text_confirm = '[Ngày chốt bill: ' . $shipment['completed_date'] ?? $shipment['created_at'] . ']';

        return $text_service . ' ' . $text_branch . ' ' . $text_packages_weight . ' ' . $text_confirm;
    } catch (\Throwable $th) {
        return 'Không tìm thấy bảng giá dịch vụ';
    }
}

function getPricePackage($packages_weight, $shipment) // package_charged_weight
{
    try {
        $country_id = $shipment['receiver_country_id'];
        $state_id = $shipment['receiver_state_id'];
        $city_id = $shipment['receiver_city_id'];

        $price_list_service = PriceList::where('price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            ->isActive(ACTIVE)->isDelete(NO_DELETE)
            ->leftJoin('price_list_user', 'price_list.price_list_id', '=', 'price_list_user.price_list_id')
            ->leftJoin('child_price_list', 'price_list.price_list_id', '=', 'child_price_list.price_list_id')
            ->leftJoin('sub_child_price_list', 'child_price_list.child_price_list_id', '=', 'sub_child_price_list.child_price_list_id')
            ->where('price_list_user.user_id', $shipment['user_id'])
            ->where('child_price_list.child_price_list_kind', CHILD_PRICE_LIST_KIND_TRANSPORT_OTHER)
            ->where('sub_child_price_list.service_id', $shipment['shipment_service_id'])
            ->select('sub_child_price_list.*')
            ->first();
        if (isset($price_list_service)) {
            $sub_child_price_list_type = $price_list_service['sub_child_price_list_type'];
            $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id');

            switch ($sub_child_price_list_type) {
                case SUB_CHILD_PRICE_LIST_TYPE_COUNTRY:
                    $sub_child_price_list->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                        ->where(function ($query) use ($packages_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->where('weight_child_price_list_area.country_id', $country_id);

                    $exists = $sub_child_price_list->exists();

                    if (!$exists) {
                        $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                            ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                            ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                            ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                            ->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->whereNull('weight_child_price_list_area.country_id');
                    }

                    $sub_child_price_list->select('items_child_price_list.*');
                    break;

                case SUB_CHILD_PRICE_LIST_TYPE_STATE:
                    $sub_child_price_list->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                        ->where(function ($query) use ($packages_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->where('weight_child_price_list_area.state_id', $state_id);

                    $exists = $sub_child_price_list->exists();

                    if (!$exists) {
                        $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                            ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                            ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                            ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                            ->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->whereNull('weight_child_price_list_area.state_id');
                    }

                    $sub_child_price_list->select('items_child_price_list.*');
                    break;

                case SUB_CHILD_PRICE_LIST_TYPE_CITY:
                    $sub_child_price_list->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                        ->where(function ($query) use ($packages_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->where('weight_child_price_list_area.city_id', $city_id);

                    $exists = $sub_child_price_list->exists();

                    if (!$exists) {
                        $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                            ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                            ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                            ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                            ->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })
                            ->whereNull('weight_child_price_list_area.city_id');
                    }

                    $sub_child_price_list->select('items_child_price_list.*');
                    break;

                case SUB_CHILD_PRICE_LIST_TYPE_POST_CODE:
                    $town_id = Town::where('town_postal_code', $shipment['receiver_postal_code'])
                        ->where('country_id', $shipment['receiver_country_id'])
                        ->where('service_id', $shipment['shipment_service_id'])
                        ->value('town_id');

                    $sub_child_price_list->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                        ->where(function ($query) use ($packages_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })->where('weight_child_price_list_area.town_id', $town_id);

                    $exists = $sub_child_price_list->exists();

                    if (!$exists) {
                        $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                            ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                            ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                            ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                            ->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                            ->where(function ($query) use ($packages_weight) {
                                $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                                    ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                                    ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                            })->whereNull('weight_child_price_list_area.town_id');
                    }

                    $sub_child_price_list->select('items_child_price_list.*');
                    break;

                default:

                    $sub_child_price_list->where(function ($query) use ($packages_weight) {
                        $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $packages_weight)
                            ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $packages_weight)
                            ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                    })
                        ->select('items_child_price_list.*');
                    break;
            }

            $sub_child_price_list = $sub_child_price_list->first()->toArray();
            return [
                'status' => HTTP_OK,
                'price' => $sub_child_price_list['item_child_price_list_amount']
            ];
        } else {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'price' => 0,
                'message' => [
                    'title' => 'Thất bại!',
                    'text' => 'Không tìm thấy bảng giá dịch vụ.',
                    'icon' => 'error',
                ]
            ];
        }
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_INTERNAL_SERVER_ERROR,
            'price' => 0,
            'message' => [
                'title' => 'Thất bại!',
                'text' => 'Không tìm thấy bảng giá dịch vụ.',
                'icon' => 'error',
            ]
        ];
    }
}

function getTotalAmountPackage($package, $shipment)
{
    try {
        $surcharge_good = PackageSg::isShow()
            ->leftJoin('packages', 'package_surchage_goods.package_id', 'packages.package_id')
            ->where('packages.delete_flg', NO_DELETE)->where('packages.active_flg', ACTIVE)
            ->where('packages.package_id', $package['package_id'])
            ->select(DB::raw('SUM(package_surchage_goods.count * package_surchage_goods.price) as total_price'))
            ->first();
        $price_sg = $surcharge_good['total_price'] ?? 0;
        $price_sevice = getPricePackage($package['package_charged_weight'], $shipment)['price'] ?? 0;

        return $price_sg + $price_sevice;
    } catch (\Throwable $th) {
        return 0;
    }
}

function getSurchargeGoodPackages($shipment_id)
{
    try {
        $pluck_price = PackageSg::isShow()
            ->leftJoin('packages', 'package_surchage_goods.package_id', '=', 'packages.package_id')
            ->where('packages.delete_flg', NO_DELETE)
            ->where('packages.active_flg', ACTIVE)
            ->where('packages.shipment_id', $shipment_id)
            ->select(DB::raw('SUM(package_surchage_goods.count * package_surchage_goods.price) as total_price'))
            ->first();

        return [
            'status' => HTTP_BAD_REQUEST,
            'price' => empty($pluck_price->toArray()['total_price']) ? 0 : $pluck_price->toArray()['total_price']
        ];
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_BAD_REQUEST,
            'price' => 0
        ];
    }
}


function refreshPrice($shipment_id)
{
    // DB::beginTransaction();
    try {
        $amount_refresh = 0;
        $shipment = Shipment::findOrFail($shipment_id);
        $user = User::findOrFail($shipment['user_id']);
        // $shipment_total_amount_old = $shipment->shipment_domestic_charges +
        //     $shipment->shipment_amount_surcharge +
        //     $shipment->shipment_collection_fee +
        //     $shipment->shipment_amount_insurance +
        //     $shipment->shipment_amount_vat +
        //     $shipment->shipment_amount_original +
        //     $shipment->shipment_amount_operating_costs -
        //     $shipment->shipment_amount_discount;

        if (onCheckPositionAccounts(SETTING_FWD_ACCOUNT, $user['position_id'])) {
            $amount_refresh = $shipment['shipment_final_amount'];
        } else {
            $amount_refresh = $shipment['shipment_amount_total_customer'];
        }

        if ($shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_WALLET) {
            // $wallet = Wallet::where('user_id', $shipment['user_id'])->first();
            // $wallet->amount += $shipment_total_amount_old;
            // $wallet->save();
            $data = [
                'kind' => PLUS,
                'user_id' => $shipment['user_id'],
                'amount' => $amount_refresh,
                'content' => $note ?? 'Hoàn tiền của đơn hàng khi cập nhật lại đơn hàng' . $shipment['shipment_code'],
            ];
            actionWallet($data);
        } elseif ($shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_REMAINING) {
            $user->user_remaining_limit -= $amount_refresh;
            $user->save();
        }

        // DB::commit();
    } catch (\Throwable $th) {
        // DB::rollBack();
        return showMessageError();
    }
}

function getTotalAmountShipment($shipment_id)
{
    $shipment = Shipment::findOrFail($shipment_id);
}

function onUpdateWalletUser($shipment_id)
{
    // DB::beginTransaction();
    $amount_minus = 0;
    try {
        $shipment = Shipment::with(['invoices'])->findOrFail($shipment_id);
        $user = User::with(['position'])->findOrFail($shipment['user_id']);
        $packages_weight = Package::isShow()->where('shipment_id', $shipment_id)->sum('package_charged_weight');

        $invoice_units = [];
        $status = HTTP_OK;
        $message = '';
        foreach ($shipment['invoices'] as $invoice) {
            $invoice_units[$invoice['invoice_unit']] = collect(config('constans.constans.invoice_units'))->filter(function ($value, $key) use ($invoice) {
                return $key == $invoice['invoice_unit'];
            })->first();
        }
        $wallet = Wallet::where('user_id', $shipment['user_id'])->first();
        if (!$wallet) {
            $wallet = Wallet::create([
                'user_id' => $shipment['user_id'],
                'amount' => 0,
            ]);
        }

        $shipment->shipment_amount_surcharge = 0;
        $surcharge_invoice = SurchargeGoods::isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where('surcharge_goods_name', 'like', '%' . $shipment['shipment_goods_name'] . '%')
            ->where(function ($query) use ($invoice_units) {
                foreach ($invoice_units as $invoice_unit) {
                    $query->orWhere('surcharge_goods_type', 'like', '%' . $invoice_unit . '%')
                        ->orWhere('surcharge_goods_type', 'like', '%' . Str::lower('KG') . '%');
                }
                return $query;
            })
            ->get()->toArray();

        $filtered_surcharge_invoice_kg = collect($surcharge_invoice)->filter(function ($value, $key) {
            return Str::lower($value['surcharge_goods_type']) == Str::lower('KG');
        })->toArray();

        foreach ($filtered_surcharge_invoice_kg as $surcharge_invoice_kg) {
            $shipment->shipment_amount_surcharge += $surcharge_invoice_kg['surcharge_goods_price'] * $packages_weight;
        }

        foreach ($shipment['invoices'] as $invoice) {
            $invoice_unit_name = $invoice_units[$invoice['invoice_unit']];
            $surcharge_invoice_filter = collect($surcharge_invoice)->filter(function ($value, $key) use ($invoice_unit_name) {
                return Str::lower($value['surcharge_goods_type']) == Str::lower($invoice_unit_name);
            })->first();

            if (isset($surcharge_invoice_filter)) {
                $shipment->shipment_amount_surcharge += $surcharge_invoice_filter['surcharge_goods_price'] * $invoice['invoice_quantity'];
            }
        }

        $shipment->shipment_amount_operating_costs = ShipmentOperatingCost::where('shipment_id', $shipment_id)
            ->selectRaw('SUM(shipment_operating_cost_amount * shipment_operating_cost_quantity) as total_cost')
            ->value('total_cost');
        $shipment_total_amount =
            $shipment->shipment_domestic_charges +
            $shipment->shipment_amount_surcharge +
            $shipment->shipment_collection_fee +
            $shipment->shipment_amount_insurance +
            $shipment->shipment_amount_vat +
            $shipment->shipment_amount_original +
            $shipment->shipment_amount_operating_costs -
            $shipment->shipment_amount_discount;
        $shipment->shipment_amount_profit = $shipment->shipment_amount_total_customer - $shipment_total_amount;

        // lấy phí tiền của tất cả surcharge goods khi dc scan imported
        $price_pg_surcharge = getSurchargeGoodPackages($shipment_id)['price'];

        if (onCheckPositionAccounts([SETTING_FWD_ACCOUNT], $user['position_id'])) {
            $amount_minus = $shipment_total_amount + $price_pg_surcharge;
        } else {
            $amount_minus = $shipment['shipment_amount_total_customer'];
        }
        if ($wallet['amount'] >= $shipment_total_amount) {
            $data = [
                'kind' => MINUS,
                'user_id' => $shipment['user_id'],
                'amount' => $amount_minus,
                'content' => 'Trừ tiền vận chuyển và dịch vụ của đơn hàng ' . $shipment['shipment_code'],
            ];
            $result = actionWallet($data);
            $shipment->shipment_payment_status = 1; // Đã thanh toán

            if ($shipment->active_flg == INACTIVE) {
                $shipment->active_flg = ACTIVE;
                $shipment->created_at = Carbon::now();
            }
            $shipment->shipment_paid_by = SHIPMENT_PAID_BY_WALLET;
        } else if (
            $user['position']['limit_amount_flg'] == NO_LIMIT || onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user->position_id)
            || ($user['position']['limit_amount_flg'] == LIMITED && $shipment_total_amount < ($user['user_limit_amount_for_sale'] - $user['user_remaining_limit']))
        ) {
            if ($user['position']['limit_amount_flg'] == LIMITED && $shipment_total_amount > ($user['user_limit_amount_for_sale'] - $user['user_remaining_limit'])) {
                $shipment->active_flg = INACTIVE;
                $shipment->save();
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => "Bạn đã đến hạn mức, không thể tiếp tục ghi nợ",
                ];
            }

            $user->user_remaining_limit += $amount_minus;
            $status = HTTP_INTERNAL_SERVER_ERROR;
            $check_fwd = onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user->position_id);
            $text_message = $check_fwd ? 'Hệ' : 'Số tiền trong ví không đủ để thực hiện giao dịch, hệ';
            $message = $text_message . ' thống sẽ ghi nợ đơn này của bạn. Vui lòng thanh toán đúng thời hạn!';
            if ($shipment->active_flg == INACTIVE) {
                $shipment->active_flg = ACTIVE;
                $shipment->created_at = Carbon::now();
            }
            $shipment->shipment_paid_by = SHIPMENT_PAID_BY_REMAINING;
            $shipment->shipment_payment_status = 0; // Chưa thanh toán

            if ($check_fwd) {
                if (Debit::isShow()->where('customer_id', $user->user_id)->where('debit_status', 2)->first()) {

                    if (Route::currentRouteName() == 'shipments.create.handle') {
                        $shipment->active_flg = INACTIVE;
                    }
                    $shipment->save();
                    return [
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => 'Bạn đang có công nợ quá hạn, hãy thanh toán để có thể tiếp tục',
                    ];
                } else {
                    $result_debit = [
                        'status' => HTTP_OK,
                        'debit_id' => $shipment->shipment_debit_id ?? null,
                    ];
                }
            } else {
                $result_debit = createDebit($user->user_id, $user->user_debit_type);
            }

            if ($result_debit['status'] == HTTP_OK) {
                $shipment->shipment_debit_id = $result_debit['debit_id'];
            } else {
                if (Route::currentRouteName() == 'shipments.create.handle') {
                    $shipment->active_flg = INACTIVE;
                }
                $shipment->save();
                return [
                    'status' => $result_debit['status'],
                    'message' => $result_debit['message'],
                ];
            }
        } else if ($user['position']['limit_amount_flg'] == LIMITED && $shipment_total_amount > ($user['user_limit_amount_for_sale'] - $user['user_remaining_limit'])) {
            if (Route::currentRouteName() == 'shipments.create.handle') {
                $shipment->active_flg = INACTIVE;
            }

            $status = HTTP_INTERNAL_SERVER_ERROR;
            $message = 'Số tiền cần thanh toán: ' . number_format($amount_minus) . '. Tiền/hạn mức của bạn không đủ để thực hiện giao dịch.';
        } else {
            if (Route::currentRouteName() == 'shipments.create.handle') {
                $shipment->active_flg = INACTIVE;
            }

            $status = HTTP_INTERNAL_SERVER_ERROR;
            $message = 'Lỗi không xác định khi thanh toán';
        }

        $shipment->shipment_final_amount = $shipment_total_amount + ($price_pg_surcharge ?? 0);
        $user->save();
        $shipment->save();
        // DB::commit();
        return [
            'status' => $status,
            'message' => $message,
        ];
    } catch (\Throwable $th) {
        // DB::rollBack();
        return [
            'status' => HTTP_BAD_REQUEST,
            'message' => "Xảy ra lỗi khi xử lý ví tiền",
        ];
    }
}

function onUpdateOperatingCostsAmount($shipment_id)
{
    // DB::beginTransaction();
    try {
        $shipment = Shipment::with(['packages'])->findOrFail($shipment_id);
        $total_packages = count($shipment['packages']);

        $operating_costs = OperatingCost::with([
            'parentOperatingCost' => function ($query) {
                return $query->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->whereNull('parent_operating_cost_id')
                    ->select('operating_cost_id', 'operating_cost_package_number_flg');
            }
        ])
            ->isActive(ACTIVE)->isDelete(NO_DELETE)
            ->whereNotNull('parent_operating_cost_id')
            ->where('operating_cost_default_flg', OPERATING_COST_AUTO_COMPUTE)
            ->get()->toArray();

        $shipment->shipment_amount_operating_costs = 0;
        ShipmentOperatingCost::where('shipment_id', $shipment_id)->delete();

        foreach ($operating_costs as $operating_cost) {
            $is_use_packages = $operating_cost['parent_operating_cost']['operating_cost_package_number_flg'];
            $shipment_operating_cost_quantity = $is_use_packages == OPERATING_COST_USE_NUMBER_PACKAGES ? $total_packages : 1;
            $shipment_operating_cost_amount = $operating_cost['operating_cost_amount'];
            $shipment->shipment_amount_operating_costs += $shipment_operating_cost_amount;

            ShipmentOperatingCost::create([
                'shipment_id' => $shipment_id,
                'operating_cost_id' => $operating_cost['operating_cost_id'],
                'shipment_operating_cost_amount' => $shipment_operating_cost_amount,
                'shipment_operating_cost_quantity' => $shipment_operating_cost_quantity,
                'shipment_operating_cost_total_amount' => $shipment_operating_cost_quantity * $shipment_operating_cost_amount,
            ]);
        }

        $shipment->save();
        // DB::commit();
    } catch (\Throwable $th) {
        // DB::rollBack();
    }
}

function getIdsAreaGobalByWords($country_name = null, $state_name = null, $city_name = null)
{
    $country_id = null;
    $state_id = null;
    $city_id = null;
    if (isset($country_name)) {
        $country = Country::isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where(function ($query) use ($country_name) {
                $query->where('country_name', 'like', $country_name)
                    ->orWhere('country_code', 'like', $country_name);
            })->select('country_id')->first();
        $country_id = $country['country_id'] ?? null;
    }

    if (isset($country_id) && isset($state_name)) {
        $state = State::isCountry($country_id)->isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where(function ($query) use ($state_name) {
                $query->where('state_name', 'like', $state_name)
                    ->orWhere('state_code', 'like', $state_name);
            })->select('state_id')->first();
        $state_id = $state['state_id'] ?? null;
    }

    if (isset($country_id) && isset($city_name)) {
        $city = City::isActive(ACTIVE)->isDelete(NO_DELETE)->isCountry($country_id);
        if (isset($state_id)) {
            $city = $city->isState($state_id);
        }
        $city = $city->where('city_name', 'like', $city_name)->select('city_id')->first();
        $city_id = $city['city_id'] ?? null;
    }

    if (!isset($country_id) || !isset($city_name)) {
        return [
            'status' => false
        ];
    } else {
        return [
            'status' => true,
            'data' => [
                'country_id' => $country_id,
                'state_id' => $state_id,
                'city_id' => $city_id
            ]
        ];
    }
}


function checkPosition($position_id, $kind)
{
    $path = 'public/config/system-settings.json';
    $position_ids = collect(json_decode(Storage::get($path), true))->firstWhere('kind', $kind)['position_ids'];
    $is_view_all_shipment = in_array($position_id, $position_ids);

    return $is_view_all_shipment;
}

function getRechargeSetting()
{
    $path = 'public/config/setting-recharge.json';
    return json_decode(Storage::get($path), true);
}

function createFileUpload($content, $path, $name, $dot_name)
{
    try {

        // $filePath = $path . 'KG' . $name . '-' . time() . '.' . $dot_name;
        // $filePath = public_path($filePath);
        // File::put($filePath, $content);
        if (empty($content) || empty($path) || empty($name) || empty($dot_name)) {
            return [
                'status' => false,
                'res' => response()->json([
                    'status' => HTTP_ACCEPTED,
                    'message' => [
                        'icon' => 'warning',
                        'title' => 'Thông báo',
                        'text' => 'Dữ liệu để tạo file bị thiếu'
                    ]
                ])
            ];
        } else {
            $path = $path . $name . '.' . $dot_name;
            file_put_contents($path, base64_decode($content));
            return [
                'status' => true,
                'path' => $path,
            ];
        }
    } catch (\Throwable $th) {
        return returnFalseWithResponse(null, 'Xảy ra lỗi khi cập nhật hình ảnh');
    }
}

//'customer_name' => receiver_contact_name,
//'customer_phone' => receiver_telephone,
//'order_create_time' => Carbon::now()->toDateTimeString(),

function createTracktry($number_code, $data)
{
    try {
        $tracktry = new Tracktry();

        $result = $tracktry->detectCarrier($number_code);
        if (isset($result['data'][0])) {
            $carrier = $result['data'][0];
        } else {
            return [
                'status' => 404,
                'message' => 'Không tìm thấy mã dịch vụ',
                'data' => [
                    'carrier_code' => '',
                    'branch_connect' => '',
                    'tracktry' => '',
                ]
            ];
        }
        if ($carrier['code'] == 'yunda') {
            $carrier['name'] = 'TOLL Global';
            $carrier['code'] = 'toll';
        }
        if ($carrier['code'] == 'dpd') {
            $carrier['name'] = 'DPD UK';
            $carrier['code'] = 'dpd-uk';
        }
        $result = $tracktry->createTracking($carrier['code'], $number_code, $data);
        if (isset($result['meta']['code']) && $result['meta']['code'] == 200) {
            return [
                'status' => 200,
                'message' => 'Thành công',
                'carrier_code' => $carrier['code'],
                'branch_connect' => $carrier['name'],
                'data' => [
                    'carrier_code' => $carrier['code'],
                    'branch_connect' => $carrier['name'],
                    'tracktry' => $result,
                ]
            ];
        } else {
            return [
                'status' => 500,
                'message' => $result['message'],
                'data' => [
                    'carrier_code' => $carrier['code'] ?? '',
                    'branch_connect' => $carrier['name'] ?? '',
                    'tracktry' => '',
                ]
            ];
            // returnFalseWithResponse(null, $result['message']);
        }
    } catch (\Throwable $th) {
        return [
            'status' => 500,
            'message' => 'Xảy ra lỗi khi khởi tạo tracktry',
            'data' => [
                'carrier_code' => '',
                'branch_connect' => '',
                'tracktry' => '',
            ]
        ];
        // returnFalseWithResponse(null, 'Xảy ra lỗi khi khởi tạo tracktry');
    }
}
function getTracktry($number_code, $carrier_code)
{
    $tracktry = new Tracktry();
    $result = $tracktry->getRealtimeTrackingResults($carrier_code, $number_code);
    if ($result['meta']['code'] == 200) {
        $data['trackings'][0] = [];

        $data['trackings'][0]['slug'] = $result['data']['carrier_code'] ?? '';
        $data['trackings'][0]['checkpoints'] = [];
        if (!empty($result['data']['items'][0]['origin_info']['trackinfo'])) {
            $trackinfo = $result['data']['items'][0]['origin_info']['trackinfo'];
            foreach ($trackinfo as $key => $value) {
                $data['trackings'][0]['checkpoints'][$key]['tag'] = $value['checkpoint_status'] ?? '';
                $data['trackings'][0]['checkpoints'][$key]['subtag'] = $value['subtag'] ?? '';
                $data['trackings'][0]['checkpoints'][$key]['message'] = $value['StatusDescription'] ?? '';
                $data['trackings'][0]['checkpoints'][$key]['location'] = $value['Details'] ?? '';
                $data['trackings'][0]['checkpoints'][$key]['checkpoint_time'] = $value['Date'] ?? '';
            }
        }
        return [
            'status' => 200,
            'message' => 'Lấy thông tin tracktry thành công',
            'tracktry' => $result['data'],
            'data' => $data,
        ];
    } else {
        return [
            'status' => 500,
            'message' => $result['meta']['message'] ?? 'Lấy thông tin tracktry thất bại',
            'tracktry' => null,
            'data' => [],
        ];
        // return returnFalseWithResponse(null, 'Lấy thông tin tracktry thất bại');
    }
}
function deleteTracktry($number_code, $carrier_code)
{
    $tracktry = new Tracktry();
    $result = $tracktry->deleteTrackingItem($carrier_code, $number_code);

    if ($result['meta']['code'] == 200) {
        return [
            'status' => true,
            'message' => "Xóa tracktry thành công",
        ];
    } else {
        return [
            'status' => false,
            'message' => "Xóa tracktry thất bại",
        ];
    }
}

function createTrackingAfterShip($tracking_code, $send_data, $carrier_code = null)
{
    try {
        $apterShip = new AfterShip();

        if (!$carrier_code) {
            $carrier = $apterShip->postCourier($tracking_code);
            if ($carrier['status'] == HTTP_OK && isset($carrier['data']['couriers'][0]['slug'])) {
                $carrier_code = $carrier['data']['couriers'][0]['slug'];
                $send_data['slug'] = $carrier_code;
                $send_data['destination_country_iso3'] = $carrier['data']['couriers'][0]['service_from_country_iso3'][0] ?? $send_data['destination_country_iso3'];
            } else {
                return [
                    "status" => HTTP_BAD_REQUEST,
                    "message" => $carrier['message'] ?? "Không tìm thấy mã carrier"
                ];
            }
        }
        $result = $apterShip->postTracking($tracking_code, $send_data);
        if ($result['status'] == 201 || in_array($result['status'], [201, HTTP_OK])) {
            return [
                "status" => HTTP_OK,
                "data" => $result['data'],
                "carrier_code" => $carrier_code,
            ];
        } else {
            return [
                "status" => HTTP_BAD_REQUEST,
                "message" => $result['message'] ?? "Tạo tracking thất bại"
            ];
        }
    } catch (\Throwable $th) {
        return [
            "status" => HTTP_BAD_REQUEST,
            "message" => "Lỗi trong quá trình tạo tracking thất bại"
        ];
    }
}

function getTrackingAfterShip($tracking_code)
{
    try {
        $apterShip = new AfterShip();
        $result = $apterShip->getTrackings($tracking_code);
        if ($result['status'] == HTTP_OK) {
            return [
                "status" => HTTP_OK,
                "message" => $result['data']
            ];
        } else {
            return [
                "status" => HTTP_BAD_REQUEST,
                "message" => $result['message'] ?? "Gọi tracking thất bại"
            ];
        }
    } catch (\Throwable $th) {
        return [
            "status" => HTTP_BAD_REQUEST,
            "message" => "Lỗi trong quá trình gọi đến tracking"
        ];
    }
}


function sendSms($phone, $content, $user_id, $bill_code = null)
{
    $url = 'https://rest.esms.vn/MainService.svc/json/SendMultipleMessage_V4_post_json/';
    $apiKey = '822E0BEC40AFE7A2236777DB603208';
    $secretKey = 'ACA11EF6C44C7B28F14C809DBAE3E9';
    $content = $content;
    $phone = $phone;
    $brandname = 'KIKI CO.LTD';
    $smsType = '2'; // Loại tin nhắn ID 2 là CSKH.
    $isUnicode = '1'; // 0: Không dấu, 1: Có dấu.
    $sandbox = '1'; // 0 có tn về máy, 1 mt test

    $response = Http::withHeaders([
        'Content-Type' => 'application/json',
    ])->post($url, [
        'ApiKey' => $apiKey,
        'Content' => $content,
        'Phone' => $phone,
        'SecretKey' => $secretKey,
        'Brandname' => $brandname,
        'SmsType' => $smsType,
        'IsUnicode' => $isUnicode,
        'Sandbox' => $sandbox,
    ]);

    $sms_data = [
        "phone" => $phone,
        "content" => $content,
        "bill_code" => $bill_code,
        "send_by" => auth()->id(),
        "send_to" => $user_id
    ];

    if ($response->status() == HTTP_OK) {
        $resul = json_decode($response->body(), true);
        $sms_data['status'] = $resul['CodeResult'] == 100 ? 1 : 0;
        $sms_data['status_content'] = config('constans.content-other.status_sms.' . $resul['CodeResult']);
    } else {
        $sms_data['status'] = 0;
        $sms_data['status_content'] = "Xảy ra lỗi khi gọi đến esms";
    }

    SmsHistory::create($sms_data);


    return $sms_data['status'] === 1 ? returnResponse(HTTP_OK) : returnResponse(HTTP_UNKNOWN_ERROR, 'Gửi thông tin nhắn sms thất bại');

    return [
        'status' => $sms_data['status'] === 1 ? HTTP_OK : HTTP_UNKNOWN_ERROR,
        'message' => "Gửi thông tin nhắn sms " . $sms_data['status'] === 1 ? "thành công" : "thất bại"
    ];
}

function checkFileInfo($filePath)
{
    if (file_exists($filePath)) {
        $fileInfo = pathinfo($filePath);
        $fileSize = round(filesize($filePath) / 1000, 2);
        $fileName = $fileInfo['filename'];
        $fileExtension = $fileInfo['extension'];

        $fileIcons = [
            'pdf' => 'ri-file-pdf-fill text-danger',
            'doc' => 'ri-file-word-2-fill',
            'docx' => 'ri-file-word-2-fill',
            'xls' => 'ri-file-excel-2-fill',
            'xlsx' => 'ri-file-excel-2-fill',
            'ppt' => 'ri-file-ppt-2-fill',
            'pptx' => 'ri-file-ppt-2-fill',
            'txt' => 'ri-file-text-fill',
            'csv' => 'ri-file-excel-2-fill',
            'mp4' => 'ri-video-add-fill',
            'avi' => 'ri-video-add-fill',
            'mov' => 'ri-video-add-fill',
            'wmv' => 'ri-video-add-fill',
        ];

        if (array_key_exists($fileExtension, $fileIcons)) {
            $fileIcon = $fileIcons[$fileExtension];
        } else {
            $fileIcon = 'ri-error-warning-fill';
        }

        return [
            'size' => $fileSize,
            'name' => $fileName,
            'extension' => $fileExtension,
            'icon' => $fileIcon,
            'is_image' => in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif'])
        ];
    } else {
        return null;
    }
}

function createDebit($user_id, $user_debit_type)
{
    try {
        if (Debit::isShow()->where('customer_id', $user_id)->where('debit_status', 2)->first()) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => 'Bạn đang có công nợ quá hạn, hãy thanh toán để có thể tiếp tục',
            ];
        }
        $debit = Debit::where('customer_id', $user_id)->where('debit_status', 0);
        // $debit = Debit::where('customer_id', $user_id)
        //     ->where('debit_type', $user_debit_type);
        switch ($user_debit_type) {
            case DEBIT_TYPE_DAY:
                $debit = $debit->whereDate('created_at', Carbon::today());
                break;

            case DEBIT_TYPE_WEEK1:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subWeek(), Carbon::now()]);
                break;

            case DEBIT_TYPE_WEEK2:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subWeeks(2), Carbon::now()]);

            case DEBIT_TYPE_MONTH:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subMonth(), Carbon::now()]);
                break;
            default:
                $debit = $debit->whereDate('created_at', Carbon::today());
                $user_debit_type = DEBIT_TYPE_DAY;
                break;
                // return [
                //     'status' => HTTP_BAD_REQUEST,
                //     'res' => returnResponse(HTTP_BAD_REQUEST, isset($user_debit_type) ? 'loại công nợ không đúng' : 'Không thể thêm vào công nợ, hãy cập nhật lại loại công nợ'),
                // ];
        }

        $debit = $debit->latest('created_at')->first();

        if (!$debit) {
            $debit = Debit::create([
                "debit_no" => initializationCode('debits', 'debit_id', 'DBN'),
                "customer_id" => $user_id,
                "created_by" => auth()->id(),
                "debit_type" => $user_debit_type
            ]);
        }
        return [
            'status' => HTTP_OK,
            'debit_id' => $debit->debit_id,
        ];
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_INTERNAL_SERVER_ERROR,
            'message' => 'Xảy ra lỗi trong quá trình khởi tạo công nợ',
        ];
    }
}

function createItemDebit($user_id, $user_debit_type, $shipment_id, $price, $content = '')
{
    try {
        $debit = Debit::where('customer_id', $user_id)
            ->where('created_by', auth()->id())
            ->where('user_debit_type', $user_debit_type);

        switch ($user_debit_type) {
            case DEBIT_TYPE_DAY:
                $debit = $debit->whereDate('created_at', Carbon::today());
                break;

            case DEBIT_TYPE_WEEK1:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subWeek(), Carbon::now()]);
                break;

            case DEBIT_TYPE_WEEK2:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subWeeks(2), Carbon::now()]);

            case DEBIT_TYPE_MONTH:
                $debit = $debit->whereBetween('created_at', [Carbon::now()->subWeeks(3), Carbon::now()]);
                break;
            default:
                return returnResponse(HTTP_BAD_REQUEST, 'loại công nợ không đúng');
        }
        $debit = $debit->latest('created_at')->first();

        if (!$debit) {
            $debit = Debit::create([
                "debit_no" => initializationCode('debits', 'debit_id', 'DBN'),
                "customer_id" => $user_id,
                "created_by" => auth()->id(),
                "debit_type" => $user_debit_type
            ]);
        }
        $item = DebitItem::where('shipment_id', $shipment_id)->isShow()->first();
        if ($item) {
            $item->update([
                "debit_item_amount" => $price,
                "debit_item_note" => empty($content) ? $item->debit_item_note : $content
            ]);
        } else {
            DebitItem::create([
                "debit_id" => $debit->debit_id,
                "shipment_id" => $shipment_id,
                "debit_item_amount" => $price,
                "debit_item_note" => $content
            ]);
        }
        return [
            'status' => 200,
            '$debit_id' => $$debit->debit_id,
        ];
    } catch (\Throwable $th) {
        return returnResponse(HTTP_BAD_REQUEST, 'Xảy ra lỗi trong quá trình khởi tạo công nợ');
    }
}

function getTeamMember($team_id, $filters = null)
{
    try {
        $data = SaleMember::isShow()->where('sale_team_id', $team_id)
            ->leftJoin('users', 'sales_members.user_id', 'users.user_id')
            ->leftJoin('shipments', function ($join) use ($filters) {
                if (
                    (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                    && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
                ) {
                    $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                    $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                    $join->on('sales_members.user_id', '=', 'shipments.user_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE)
                        ->whereBetween("shipments.created_at", [$start_date, $end_date]);
                } else {
                    $join->on('sales_members.user_id', '=', 'shipments.user_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE);
                }
            })
            ->where('users.delete_flg', NO_DELETE)
            ->select(
                'sale_member_id',
                'member_kind',
                'users.user_contact_name',
                'sales_members.user_id',
                'users.user_code',
                // DB::raw("CASE 
                //     WHEN shipments.shipment_payment_status = 0 THEN 0 
                //     WHEN shipments.shipment_status IN (0, 3, 4) THEN 0 
                //     ELSE shipments.shipment_amount_profit 
                // END as member_profit"),
                DB::raw('COALESCE(SUM(shipment_amount_profit), 0) as member_profit')
            )->groupBy('sales_members.sale_member_id')->get()->toArray();

        return $data;
    } catch (\Throwable $th) {
        return [];
    }
}


function getNameBranchsById()
{
    try {
        $branchs = Branch::isShow()
            ->select('branch_name', 'branch_id')
            ->get()->toArray();

        $new_branchs = [];
        foreach ($branchs as $key => $branch) {
            $new_branchs[$branch['branch_id']] = $branch['branch_name'];
        }

        return $new_branchs;
    } catch (\Throwable $th) {
        abort('404');
    }
}

function checkSelectChildPriceService($data, $id)
{
    $resul = collect($data)->firstWhere('child_price_list_id', $id);

    return $resul ? true : false;
}



function getRangeSaleKpi($kpis, $revenue)
{
    try {
        $filtered = collect($kpis)->filter(function ($item) use ($revenue) {
            return ($revenue >= $item['profit_start'] && $revenue < $item['profit_end']) || $revenue >= $item['profit_end'];
        });
        $maxStartItem = $filtered->sortByDesc('profit_end')->first();
        return $maxStartItem;

        $result = null; // Khởi tạo kết quả

        foreach ($kpis as $item) {
            if ($item['profit_start'] <= $revenue && $revenue < $item['profit_end']) {
                $result = $item;
                break; // Thoát vòng lặp ngay khi tìm được phần tử thỏa mãn
            }
        }

        if ($result) {
            return $result;
        } else {
            return null;
        }
    } catch (\Throwable $th) {
        return null;
    }
}

function onGetTotalSalarySale($profit, $ratio_commission, $salary, $cost_fwd, $other = 0)
{
    $amount = ($profit * $ratio_commission / 100) + $salary + $cost_fwd + $other;
    return $amount;
}

function onGetTotalWeightByFwd($fwd_id, $range_date)
{

    $cost_fwds = [];
    $team = SaleMember::isShow()->where('sale_member_id', $fwd_id)
        ->leftJoin('sales_teams', 'sales_members.sale_team_id', 'sales_teams.sale_team_id')
        ->leftJoin('fwd_costs', 'sales_teams.leader_id', 'fwd_costs.leader_id')
        ->select('fwd_costs.*')->groupBy('fwd_costs.leader_id')->get()->toArray();

    $shipment = Shipment::isShow()->where('user_id', $fwd_id)
        ->leftJoin('packages', 'shipments.shipment_id', 'packages.shipment_id')
        ->select(
            'shipments.shipment_id',
            'shipments.user_id',
            DB::raw('SUM(package_charged_weight) as shipment_charge_weight')
        )->groupBy('shipments.shipment_id')->get();
}

function updateDebitStatus()
{
    try {
        $debit_day = Debit::isShow()->where('debit_status', 0)
            ->whereNull('debit_payment_date')
            ->where(function ($query) {
                $query->where('debit_type', DEBIT_TYPE_DAY)
                    ->whereDate('created_at', '!=', Carbon::today());
            })
            ->orWhere(function ($query) {
                $query->where('debit_type', DEBIT_TYPE_WEEK1)
                    ->whereNotBetween('created_at', [Carbon::now()->subWeek(), Carbon::now()]);
            })
            ->orWhere(function ($query) {
                $query->where('debit_type', DEBIT_TYPE_WEEK2)
                    ->whereNotBetween('created_at', [Carbon::now(2)->subWeek(), Carbon::now()]);
            })
            ->orWhere(function ($query) {
                $query->where('debit_type', DEBIT_TYPE_DAY)
                    ->whereNotBetween('created_at', [Carbon::now()->subMonth(), Carbon::now()]);
            })
            ->update(['debit_status' => FAIL]);
        Debit::isShow()->where('debit_status', '!=', 1)
            ->whereNotNull('debit_payment_date')
            ->update(['debit_status' => 1]);
    } catch (\Throwable $th) {
        abort('404');
    }
}

function checkDebitStatus($user_id, $status = FAIL)
{
    try {
        return Debit::isShow()->where('customer_id', $user_id)->where('debit_status', $status)->exists();
    } catch (\Throwable $th) {
        return false;
    }
}

function onCheckAdminAccount($kind = SETTING_ADMIN_ACCOUNT)
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $admin = collect($system_settings)->firstWhere('kind', $kind);

        return request()->user()['position_id'] == $admin['position_id'];
    } catch (\Throwable $th) {
        return false;
    }
}

function onCheckAccountantAccount($kind = SETTING_ACCOUNTANT_ACCOUNT)
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $setting_accountant_account = collect($system_settings)->firstWhere('kind', $kind);

        return request()->user()['position_id'] == $setting_accountant_account['position_id'];
    } catch (\Throwable $th) {
        return false;
    }
}

function onGetPositionIdFWDAccount()
{
    try {
        $kind = SETTING_FWD_ACCOUNT;
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $setting_fwd_account = collect($system_settings)->firstWhere('kind', $kind);

        return $setting_fwd_account['position_id'] ?? 0;
    } catch (\Throwable $th) {
        return 0;
    }
}

function onCheckDocumentAccount($kind = SETTING_DOCUMENT_ACCOUNT)
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $setting_document_account = collect($system_settings)->firstWhere('kind', $kind);

        return request()->user()['position_id'] == $setting_document_account['position_id'];
    } catch (\Throwable $th) {
        return false;
    }
}

function settingPrintBillType()
{
    $path = 'public/config/system-settings.json';
    $system_settings = json_decode(Storage::get($path), true);
    $position_ids = collect($system_settings)->firstWhere('kind', SETTING_PRINT_BILL_TYPE)['position_ids'] ?? [];

    return in_array(auth()->user()['position_id'], $position_ids);
}

function isGetAllData()
{
    try {
        if (request()->user()) {
            return onCheckAdminAccount() || onCheckAccountantAccount() || onCheckDocumentAccount();
        } else {
            return onCheckPositionAccounts(
                [
                    SETTING_ADMIN_ACCOUNT,
                    SETTING_ACCOUNTANT_ACCOUNT,
                    SETTING_DOCUMENT_ACCOUNT
                ],
                auth()->user()['position_id']
            );
        }
    } catch (\Throwable $th) {
        return false;
    }
}

function onCheckSaleAccount($kind = SETTING_SALE_ACCOUNT)
{
    $path = 'public/config/system-settings.json';
    $system_settings = json_decode(Storage::get($path), true);
    $sale = collect($system_settings)->firstWhere('kind', $kind);

    return auth()->user()['position_id'] == $sale['position_id'];
}

function getSaleSalaryAndKpi($kpi_id, $revenue)
{
    try {
        $sale = SaleKpi::isShow()
            ->where('sale_kpis.sale_kpi_id', $kpi_id) // Chỉ rõ sale_kpis.sale_kpi_id
            ->leftJoin('range_kpis', 'sale_kpis.sale_kpi_id', '=', 'range_kpis.sale_kpi_id')
            ->where('range_kpis.delete_flg', NO_DELETE)
            ->where(function ($query) use ($revenue) {
                $query->where(function ($subQuery) use ($revenue) {
                    $subQuery->where('profit_start', '<=', $revenue)
                        ->where('profit_end', '>', $revenue);
                })
                    ->orWhere('profit_end', '<', $revenue);
            })
            ->select(
                'salary',
                'range_kpi_name',
                'ratio_commission',
                'leader_have_commission',
            )
            ->orderBy('profit_start', 'DESC')
            ->first();

        if (!$sale) {
            return [
                'salary' => 0,
                'ratio_commission' => 0,
                'range_kpi_name' => "Sale chưa đạt được kpi",
                'leader_have_commission' => 0,
            ];
        }
        return $sale;
    } catch (\Throwable $th) {
        return [
            'salary' => 0,
            'ratio_commission' => 0,
            'range_kpi_name' => "Sale chưa gắn kpi",
            'leader_have_commission' => 0,
        ];
    }
}

function onCheckSettingAccountEditOrderPickup()
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $check_setting = collect($system_settings)->firstWhere('kind', SETTING_ACCOUNT_EDIT_ORDER_PICKUP);
        if (empty($check_setting['position_ids'])) {
            return false;
        }
        return in_array(request()->user()['position_id'], $check_setting['position_ids']);
    } catch (\Throwable $th) {
        return false;
    }
}

function checkShowInfoPickup($is_shipper, $status)
{
    try {
        if ($is_shipper && $status == ORDER_PICKUP_STATUS_PICKED) {
            return "Thông tin ẩn";
        }
        return null;
    } catch (\Throwable $th) {
        return "Thông tin ẩn";
    }
}

function onCheckPositionAccount($position_id, $user_position, $system_settings = null)
{
    try {
        if (empty($system_settings)) {
            $path = 'public/config/system-settings.json';
            $system_settings = json_decode(Storage::get($path), true);
        }
        $account = collect($system_settings)->firstWhere('kind', $position_id);
        if (isset($account['position_ids'])) {
            return in_array($user_position, $account['position_ids']);
        }
        if (isset($account['position_id'])) {
            return $account['position_id'] == $user_position;
        }
        return false;
    } catch (\Throwable $th) {
        return false;
    }
}

function onCheckPositionAccounts($position_ids, $user_position, $system_settings = null)
{
    try {
        if (empty($system_settings)) {
            $path = 'public/config/system-settings.json';
            $system_settings = json_decode(Storage::get($path), true);
        }

        $accounts = collect($system_settings)->whereIn('kind', $position_ids);

        foreach ($accounts as $account) {
            if (isset($account['position_ids']) && is_array($account['position_ids'])) {
                if (in_array($user_position, $account['position_ids'])) {
                    return true;
                }
            }

            if (isset($account['position_id']) && $account['position_id'] == $user_position) {
                return true;
            }
        }

        return false;
    } catch (\Throwable $th) {
        return false;
    }
}

function getPositionKind($user_position_id)
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);

        $account = collect($system_settings)->where('model', 'Position')
            ->where('position_id', $user_position_id)->first();

        return $account['kind'] ?? '';
    } catch (\Throwable $th) {
        return '';
    }
}

function getPositionAccountSetting($position_id = SETTING_SALE_ACCOUNT)
{
    try {
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $sale = collect($system_settings)->firstWhere('kind', $position_id);

        return $sale['position_id'];
    } catch (\Throwable $th) {
        return -1;
    }
}

function convertBase64ToPdf($name, $base64, $public_path)
{
    try {
        $directoryToCheck = public_path($public_path);
        if (!File::exists($directoryToCheck)) {
            File::makeDirectory($directoryToCheck, 0777, true, true);
        }

        $name = "$name.pdf";

        $location = public_path("$public_path$name");
        file_put_contents($location, base64_decode($base64));

        return "$public_path$name";
    } catch (\Throwable $th) {
        return '';
    }
}

function convertStringToFileTxt($name, $string, $public_path)
{
    try {
        $directoryToCheck = public_path($public_path);
        if (!File::exists($directoryToCheck)) {
            File::makeDirectory($directoryToCheck, 0777, true, true);
        }

        $name = "$name.txt";

        $location = public_path("$public_path$name");
        file_put_contents($location, $string);

        return "$public_path$name";
    } catch (\Throwable $th) {
        return '';
    }
}

function createLabelEpackage($label)
{
    DB::beginTransaction();
    try {
        if (isset($label['shipment_id'])) {
            ModelsLabelNz::isShow()->where("shipment_id", $label['shipment_id'])->update(['delete_flg' => DELETED]);
        }
        ModelsLabelNz::create($label);
        DB::commit();
    } catch (\Throwable $th) {
        DB::rollBack();
    }
}


function getItemSettingSideBar($routeToFind, $select_name)
{
    try {
        $path = 'public/config/system-sidebars-settings.json';
        $data = json_decode(Storage::get($path), true) ?? [];
        if (empty($data)) {
            return null;
        }
        return collect($data)->flatMap(function ($item) {
            return $item['menus'] ?? [];
        })->firstWhere('route', $routeToFind)[$select_name] ?? null;
    } catch (\Throwable $th) {
        return null;
    }
}

function getStorageMenuSaleSetting($key_where, $key_value, $select_name)
{
    try {
        $path = 'public/config/system-menu-sale.json';
        $data = json_decode(Storage::get($path), true) ?? [];
        if (empty($data)) {
            return null;
        }
        return collect($data)->firstWhere($key_where, $key_value)[$select_name] ?? null;
    } catch (\Throwable $th) {
        return null;
    }
}

function onCheckShowSideBars($route, $user_id, $postion_id, $data = null)
{

    try {
        if (empty($data)) {
            $path = 'public/config/system-sidebars-settings.json';
            $data = json_decode(Storage::get($path), true) ?? [];
        }
        foreach ($data as $menuGroup) {
            foreach ($menuGroup['menus'] as $menu) {
                if ($menu['route'] === $route) {
                    // Kiểm tra nếu is_all = true hoặc user_id có trong user_ids
                    if (
                        auth()->user()['user_name'] == 'admin@kango.com' ||
                        onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']) ||
                        // (in_array($user_id, $menu['user_ids']) && $menu['type'] == 1) ||
                        // (in_array($user_id, $menu['position_ids']) && $menu['type'] == 2) ||
                        in_array($user_id, $menu['user_ids']) ||
                        in_array($postion_id, $menu['position_ids']) ||
                        $menu['is_all'] === true
                    ) {
                        return true;
                    }
                }
            }
        }
        return false;
    } catch (\Throwable $th) {
        return false;
    }
}

function readFiles($images = [])
{
    try {
        $files_info = [];
        $images = is_string($images) ? json_decode($images) : $images;
        foreach ($images as $key => $image) {
            $files_info[] = array(
                "name" => File::name($image),
                "size" => File::size($image),
                "path" => url($image),
                'normal' => $image
            );
        }
        return $files_info;
    } catch (\Throwable $th) {
        $corrupted_image = 'assets/images/corrupted-image.png';
        return [
            [
                "name" => File::name($corrupted_image),
                "size" => File::size($corrupted_image),
                "path" => url($corrupted_image),
                'normal' => $corrupted_image
            ]
        ];
    }
}
function getDataVNpay()
{
    try {
        $path = 'public/config/system-sidebars-settings.json';
        $system = json_decode(Storage::get($path), true) ?? [];
        if (!empty($system)) {
            $system = collect($system)->firstWhere('kind', SETTING_KEY_VNP);

            $vnp_TmnCode = $system['data']['tmn_code'] ?? env('VNP_TMN_CODE'); //Mã định danh merchant kết nối (Terminal Id)
            $vnp_HashSecret = $system['data']['hash_secret'] ?? env('VNP_HASH_SECRET'); //Secret key
        } else {
            $vnp_TmnCode = env('VNP_TMN_CODE'); //Mã định danh merchant kết nối (Terminal Id)
            $vnp_HashSecret = env('VNP_HASH_SECRET'); //Secret key
        }
        return [
            "vnp_TmnCode" => $vnp_TmnCode,
            "vnp_HashSecret" => $vnp_HashSecret,
        ];
    } catch (\Throwable $th) {
        return [
            "vnp_TmnCode" => '',
            "vnp_HashSecret" => '',
        ];
    }
}

function onReturnVnpay($request_data)
{
    // Lấy các tham số từ query string
    $vnp_SecureHash = $request_data['vnp_SecureHash'];
    $inputData = [];

    // Lọc các tham số có tiền tố "vnp_"
    foreach ($request_data as $key => $value) {
        if (substr($key, 0, 4) == "vnp_") {
            $inputData[$key] = $value;
        }
    }
    // Xóa vnp_SecureHash ra khỏi dữ liệu để kiểm tra
    unset($inputData['vnp_SecureHash']);
    ksort($inputData);

    // Chuỗi hash dữ liệu
    $hashData = urldecode(http_build_query($inputData));

    // Vnp_HashSecret: Khóa bí mật của bạn từ VNPAY
    $vnp_HashSecret = getDataVNpay()['vnp_HashSecret']; // Nên lưu trong file .env
    $secureHash = hash_hmac('sha512', $hashData, $vnp_HashSecret);

    $resText = config('constans.messages.vnp_ResponseCode');
    if ($secureHash === $vnp_SecureHash) {
        if ($request_data['vnp_ResponseCode'] == '00') {
            // Giao dịch thành công
            return [
                "status" => HTTP_OK,
                "message" => "Giao dịch thành công"
            ];
            // return response()->json(['message' => 'Giao dịch thành công'], 200);
        } else {
            return [
                "status" => 400,
                "message" => $resText[$request_data['vnp_ResponseCode']] ?? "Giao dịch không thành công"
            ];
            // Giao dịch không thành công
            // return response()->json(['message' => 'Giao dịch không thành công'], 400);
        }
    } else {
        // Chữ ký không hợp lệ
        return [
            "status" => 400,
            "message" => $resText[$request_data['vnp_ResponseCode']] ?? "Chữ ký không hợp lệ"
        ];
        // return response()->json(['message' => 'Chữ ký không hợp lệ'], 400);
    }
}

function writeFileText($content = null, $path = null)
{
    $result = [];
    try {
        $name = $path;
        if (!isset($path)) {
            $name = 'uploads/file' . '/' . time() . '.txt';
        }
        $filePath = public_path($name);
        File::put($filePath, $content);
        $result['status'] = true;
        $result['name'] = $name;
    } catch (\Exception $th) {
        $result['status'] = false;
        $result['name'] = '';
    }
    return $result;
}
function readFileText($url)
{
    $result = [];
    try {
        if (empty($url)) {
            $result['content'] = ''; // Sử dụng hàm "get" để đọc nội dung của file
            $result['status'] = false;
            return $result;
        }
        $filePath = public_path($url);
        if (File::exists($filePath)) { // Kiểm tra xem file có tồn tại hay không
            $result['content'] = File::get($filePath); // Sử dụng hàm "get" để đọc nội dung của file
            $result['status'] = true;
        } else {
            $result['content'] = 'Ko tìm thấy file'; // Sử dụng hàm "get" để đọc nội dung của file
            $result['status'] = false;
        }
    } catch (\Throwable $th) {
        $result['content'] = 'Xảy ra lỗi !!!!'; // Sử dụng hàm "get" để đọc nội dung của file
        $result['status'] = false;
    }

    return $result;
}

function explodeAwbCode($input)
{
    try {
        $parts = explode(' ', $input);

        // Kiểm tra nếu có hai phần
        if (count($parts) == 2) {
            $left = $parts[0]; // Giá trị bên trái
            $right = $parts[1]; // Giá trị bên phải

            return [
                'left' => $left,
                'right' => $right
            ];
        } else {
            return [
                'left' => '',
                'right' => ''
            ];
        }
    } catch (\Throwable $th) {
        return [
            'left' => '',
            'right' => ''
        ];
    }
}

function getAreaVietName($city = null, $district = null, $ward = null)
{
    try {
        $cities = collect(config('constans.area'))->pluck('name')->toArray();
        $areas = [
            'cities' => $cities,
            'districts' => [],
            'wards' => [],
        ];
        if (isset($city) || $city !== "") {
            $areas['districts'] = collect(config('constans.area.' . $city . '.districts'))->pluck('name')->toArray();
        }
        if ((isset($city) || $city !== "") && (isset($district) || $district !== "")) {
            $areas['wards'] = collect(config('constans.area.' . $city . '.districts.' . $district . '.wards'))->pluck('name')->toArray();
        }

        return $areas;
    } catch (\Throwable $th) {
        return [
            'cities' => [],
            'districts' => [],
            'wards' => [],
        ];
    }
}

function getUser($user_id)
{
    return User::find($user_id);
}

function isUserIdsShipment()
{
    $user_id = request()->user()['user_id'];
    $user_ids = [
        259,
    ];

    if (in_array($user_id, $user_ids)) {
        return true;
    }
    return false;
}


function onCreateCheckedPaymentCash($code, $account_id, $customer_id, $kind, $amount, $payment_at, $method = CASH, $images = '', $bank = null, $cash = null)
{
    try {
        $data = [
            'code' => $code,
            'account_id' => $account_id,
            'customer_id' => $customer_id,
            'checked_by' => auth()->id(),
            'kind' => $kind,
            'payment_method' => $method,
            'amount' => $amount,
            'amount_cash' => $method == CASH ? $amount : 0,
            'amount_bank' => $method == BANK ? $amount : 0,
            'payment_at' => $payment_at,
            'images' => $images,
            'checked_note' => $checked_note ?? null,
        ];
        if(isset($bank) && is_numeric($bank)){
           $data['amount_bank'] = $bank ?? $data['amount_bank'];
        }
        if($cash && is_numeric($cash)){
           $data['amount_cash'] = $cash ?? $data['amount_cash'];
        }
        if (!CheckedPaymentCash::where('delete_flg', NO_DELETE)->where('code', $code)->first()) {
            CheckedPaymentCash::create($data);
        } else {
            $data['active_flg'] = ACTIVE;
            CheckedPaymentCash::where('delete_flg', NO_DELETE)
                ->where('code', $code)->update($data);
        }
        return [
            'status' => HTTP_OK
        ];
    } catch (\Throwable $th) {
        return [
            'status' => HTTP_BAD_REQUEST,
            'message' => 'Xảy ra lỗi khi khởi tạo lịch sử thanh toán tiền mặt!'
        ];
    }
}



function computedPricePackage($charged_weight, $shipment)
{
    try {
        $country_id = $shipment['receiver_country_id'];
        $state_id = $shipment['receiver_state_id'];
        $city_id = $shipment['receiver_city_id'];
        $branch_id = $shipment['shipment_branch_id'];
        $package_weight = $charged_weight;
        $service_applicable_weight = $shipment['service']['service_applicable_weight'];
        $user = User::findOrFail($shipment['user_id']);

        $shipment_created_at = Carbon::parse($shipment['created_at'])->format('Y-m-d');
        $price_list_service = PriceList::where('price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            ->isActive(ACTIVE)->isDelete(NO_DELETE)
            ->leftJoin('child_price_list', 'price_list.price_list_id', '=', 'child_price_list.price_list_id')
            ->leftJoin('sub_child_price_list', 'child_price_list.child_price_list_id', '=', 'sub_child_price_list.child_price_list_id')
            ->where('child_price_list.branch_id', $branch_id)
            ->where('child_price_list.position_id', $user['position_id'])
            ->where('child_price_list.user_type', $user['user_price_list_main_type'])
            ->where(function ($query) use ($shipment_created_at) {
                $query->whereNull('price_list_start_date')
                    ->whereNull('price_list_end_date')
                    ->orWhere(function ($query) use ($shipment_created_at) {
                        $query->where('price_list_start_date', '<=', $shipment_created_at)
                            ->where('price_list_end_date', '>=', $shipment_created_at);
                    });
            })
            ->where('child_price_list.child_price_list_kind', CHILD_PRICE_LIST_KIND_TRANSPORT_OTHER)
            ->where('sub_child_price_list.service_id', $shipment['shipment_service_id'])
            ->select('sub_child_price_list.*')
            ->first();

        $sub_child_price_list_type = $price_list_service['sub_child_price_list_type'];

        $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
            ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
            ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
            ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id');

        switch ($sub_child_price_list_type) {
            case SUB_CHILD_PRICE_LIST_TYPE_COUNTRY:
                $sub_child_price_list->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                    ->where(function ($query) use ($package_weight) {
                        $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                            ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                            ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                    })
                    ->where('weight_child_price_list_area.country_id', $country_id);

                $exists = $sub_child_price_list->exists();

                if (!$exists) {
                    $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                        ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                        ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                        ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                        ->leftJoin('countries', 'weight_child_price_list_area.country_id', '=', 'countries.country_id')
                        ->where(function ($query) use ($package_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->whereNull('weight_child_price_list_area.country_id');
                }

                $sub_child_price_list->select('items_child_price_list.*');
                break;

            case SUB_CHILD_PRICE_LIST_TYPE_STATE:
                $sub_child_price_list->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                    ->where(function ($query) use ($package_weight) {
                        $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                            ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                            ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                    })
                    ->where('weight_child_price_list_area.state_id', $state_id);

                $exists = $sub_child_price_list->exists();

                if (!$exists) {
                    $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                        ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                        ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                        ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                        ->leftJoin('states', 'weight_child_price_list_area.state_id', '=', 'states.state_id')
                        ->where(function ($query) use ($package_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->whereNull('weight_child_price_list_area.state_id');
                }

                $sub_child_price_list->select('items_child_price_list.*');
                break;

            case SUB_CHILD_PRICE_LIST_TYPE_CITY:
                $sub_child_price_list->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                    ->where(function ($query) use ($package_weight) {
                        $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                            ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                            ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                    })
                    ->where('weight_child_price_list_area.city_id', $city_id);

                $exists = $sub_child_price_list->exists();

                if (!$exists) {
                    $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                        ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                        ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                        ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                        ->leftJoin('cities', 'weight_child_price_list_area.city_id', '=', 'cities.city_id')
                        ->where(function ($query) use ($package_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })
                        ->whereNull('weight_child_price_list_area.city_id');
                }

                $sub_child_price_list->select('items_child_price_list.*');
                break;

            case SUB_CHILD_PRICE_LIST_TYPE_POST_CODE:
                $town_id = Town::where('town_postal_code', $shipment['receiver_postal_code'])
                    ->where('country_id', $shipment['receiver_country_id'])
                    ->where('service_id', $shipment['shipment_service_id'])
                    ->value('town_id');

                $sub_child_price_list->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                    ->where(function ($query) use ($package_weight) {
                        $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                            ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                            ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                    })->where('weight_child_price_list_area.town_id', $town_id);

                $exists = $sub_child_price_list->exists();

                if (!$exists) {
                    $sub_child_price_list = SubChildPriceList::where('sub_child_price_list.sub_child_price_list_id', $price_list_service['sub_child_price_list_id'])
                        ->leftJoin('weights_child_price_list', 'sub_child_price_list.sub_child_price_list_id', '=', 'weights_child_price_list.sub_child_price_list_id')
                        ->leftJoin('items_child_price_list', 'weights_child_price_list.weight_child_price_list_id', '=', 'items_child_price_list.weight_child_price_list_id')
                        ->leftJoin('weight_child_price_list_area', 'weights_child_price_list.weight_child_price_list_id', '=', 'weight_child_price_list_area.weight_child_price_list_id')
                        ->leftJoin('town', 'weight_child_price_list_area.town_id', '=', 'town.town_id')
                        ->where(function ($query) use ($package_weight) {
                            $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                                ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                                ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                        })->whereNull('weight_child_price_list_area.town_id');
                }

                $sub_child_price_list->select('items_child_price_list.*');
                break;

            default:

                $sub_child_price_list->where(function ($query) use ($package_weight) {
                    $query->where('items_child_price_list.item_child_price_list_from_weight', '<=', $package_weight)
                        ->where('items_child_price_list.item_child_price_list_to_weight', '>=', $package_weight)
                        ->orWhereIn('items_child_price_list.item_child_price_list_weight_range_flg', [ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER, ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER]);
                })
                    ->select('items_child_price_list.*');
                break;
        }
        $sub_child_price_list = $sub_child_price_list->first();
        return $package_weight >= $service_applicable_weight ? $package_weight * $sub_child_price_list['item_child_price_list_amount'] : $sub_child_price_list['item_child_price_list_amount'];
    } catch (\Throwable $th) {
        return 0;
    }
}

/**
 * Lưu lại số tiền thực tế của lô hàng
 * @param mixed $shipment_id
 * @return void
 */
function onSaveAmountShipmentActual($shipment_id)
{
    DB::beginTransaction();
    try {
        $shipment = Shipment::findOrFail($shipment_id);
        $shipment->shipment_amount_operating_costs = ShipmentOperatingCost::where('shipment_id', $shipment_id)
            ->selectRaw('SUM(shipment_operating_cost_amount * shipment_operating_cost_quantity) as total_cost')
            ->value('total_cost');

        $shipment_total_amount =
            $shipment->shipment_domestic_charges +
            $shipment->shipment_amount_surcharge +
            $shipment->shipment_collection_fee +
            $shipment->shipment_amount_insurance +
            $shipment->shipment_amount_vat +
            $shipment->shipment_amount_original +
            $shipment->shipment_amount_operating_costs -
            $shipment->shipment_amount_discount;

        // lấy phí tiền của tất cả surcharge goods khi dc scan imported
        $price_pg_surcharge = getSurchargeGoodPackages($shipment_id)['price'];

        $shipment->shipment_amount_service_actual = collect($shipment['packages'])->sum('package_price_actual');
        $shipment->shipment_total_amount_actual = $shipment_total_amount
            + ($price_pg_surcharge ?? 0)
            + $shipment->shipment_amount_service_actual
            - $shipment->shipment_amount_service;

        $shipment->save();

        DB::commit();
    } catch (\Throwable $th) {
        DB::rollBack();
    }
}

/**
 * Thanh toán và trừ tiền từ ví của gói hàng e-packet
 * 
 * @param mixed $shipment_id
 * @param mixed $data
 */
function chargeAndDeductFromWallet($shipment_id, $data)
{
    DB::beginTransaction();
    try {
        $shipment = Shipment::findOrFail($shipment_id);
        $package = Package::where('package_hawb_code', $data['code'])->first();
        $wallet = Wallet::where('user_id', $shipment['user_id'])->first();

        $package_approve = PACKAGE_APPROVE_PAID;

        // Lấy tiền của thùng hàng hiện tại trước khi scan
        $current_amount_package = $package['package_price'];
        // Lấy số tiền còn lại của thùng hàng hiện tại sau khi scan
        $current_amount_package_after_scan = $package['package_price_actual'];
        // Số tiền chênh lệch giữa tiền thùng hàng trước và sau khi scan
        $diff_amount_package = $current_amount_package_after_scan - $current_amount_package;

        // Số tiền phụ thu của gói hàng
        $total_surcharge_goods = PackageSg::where('package_id', $package['package_id'])
            ->sum(DB::raw('price * count'));
        if ($total_surcharge_goods > 0) {
            if ($wallet['amount'] < $total_surcharge_goods) {
                $package_approve = PACKAGE_APPROVE_PAYMENT_FAIL;
            }
            $wallet['amount'] -= $total_surcharge_goods;
            WalletFluctuation::create([
                'wallet_id' => $wallet['wallet_id'],
                'secure_hash' => 'WF' . Carbon::now()->format('YmdHisv'),
                'user_id' => $shipment['user_id'],
                'amount' => $total_surcharge_goods,
                'wallet_amount' => $wallet['amount'],
                'content' => 'Thanh toán thêm tiền phụ thu mặt hàng của gói hàng khi xác thực có mã: ' . $package['package_hawb_code'],
                'kind' => MINUS,
            ]);
        }

        $text_content = ', chênh lệch cân nặng khi scan imported hiện tại là: ' . $package['package_charged_weight'] - $package['package_charged_weight_actual'] . 'kg';
        // Cập nhật lại số tiền trong ví của người dùng khi cập nhật lại số tiền thực tế của gói hàng
        if ($diff_amount_package > 0) {
            if ($wallet['amount'] < $diff_amount_package) {
                $package_approve = PACKAGE_APPROVE_PAYMENT_FAIL;
            }
            $wallet['amount'] -= $diff_amount_package;
            WalletFluctuation::create([
                'wallet_id' => $wallet['wallet_id'],
                'secure_hash' => 'WF' . Carbon::now()->format('YmdHisv'),
                'user_id' => $shipment['user_id'],
                'amount' => $diff_amount_package,
                'wallet_amount' => $wallet['amount'],
                'content' => 'Thanh toán thêm tiền của gói hàng khi xác thực có mã: ' . $package['package_hawb_code'] . $text_content,
                'kind' => MINUS,
            ]);
        } else if ($diff_amount_package < 0) {
            $package_approve = PACKAGE_APPROVE_HAVE_MORE_MONEY;
            $wallet['amount'] += abs($diff_amount_package);
            WalletFluctuation::create([
                'wallet_id' => $wallet['wallet_id'],
                'secure_hash' => 'WF' . Carbon::now()->format('YmdHisv'),
                'user_id' => $shipment['user_id'],
                'amount' => abs($diff_amount_package),
                'wallet_amount' => $wallet['amount'],
                'content' => 'Hoàn trả lại số tiền dư cho gói hàng có mã: ' . $package['package_hawb_code'] . $text_content,
                'kind' => PLUS,
            ]);
        }

        $package->package_approve = $package_approve;
        $package->save();
        $wallet->save();

        DB::commit();
    } catch (\Throwable $th) {
        DB::rollBack();
    }
}

/**
 * Cập nhật lại số tiền trong ví khi cập nhật lại chi phí của lô hàng
 * @param mixed $shipment_id
 * @param mixed $price_old
 * @return array
 */
function allocateFundsWhenUpdatingShipment($shipment_id, $price_old = 0, $is_update = false)
{
    // Lấy thông tin lô hàng
    $shipment = Shipment::findOrFail($shipment_id);
    // Lấy thông tin ví của người dùng
    $wallet = Wallet::where('user_id', $shipment['user_id'])->first();

    // Trả lại tiền cho người dùng khi cập nhật lại chi phí của lô hàng và lô hàng đã thanh toán
    if ($is_update && $shipment['shipment_payment_status'] == SUCCESS) {
        $wallet['amount'] += $price_old;
        WalletFluctuation::create([
            'wallet_id' => $wallet['wallet_id'],
            'secure_hash' => 'WF' . Carbon::now()->format('YmdHisv'),
            'user_id' => $shipment['user_id'],
            'amount' => $price_old,
            'wallet_amount' => $wallet['amount'],
            'content' => 'Hoàn trả lại số tiền khi cập nhật cho lô hàng có mã: ' . $shipment['shipment_code'],
            'kind' => PLUS,
        ]);
    }

    // Lấy số tiền hiện tại của lô hàng
    $current_price = $shipment['shipment_final_amount'];

    // Lấy loại giao dịch trừ tiền hoặc cộng tiền
    $history_wallet_kind = MINUS;
    // Lấy nội dung giao dịch
    if ($is_update) {
        $history_wallet_content = 'Tính lại chi phí khi chỉnh sửa lô hàng có mã: ' . $shipment['shipment_code'];
    } else {
        $history_wallet_content = 'Chi phí của lô hàng có mã: ' . $shipment['shipment_code'];
    }

    // Nếu không có ví thì tạo mới
    if (!$wallet) {
        $wallet = Wallet::create([
            'user_id' => $shipment['user_id'],
            'amount' => 0,
        ]);
    }

    // Cập nhật số tiền trong ví của người dùng
    switch ($history_wallet_kind) {
        case MINUS:
            if ($wallet['amount'] < $current_price) {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => 'Số tiền trong ví không đủ để thực hiện giao dịch'
                ];
            }
            $wallet['amount'] -= $current_price;
            break;
        default:
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => 'Loại giao dịch không hợp lệ'
            ];
    }
    $wallet->save();

    WalletFluctuation::create([
        'wallet_id' => $wallet['wallet_id'],
        'secure_hash' => 'WF' . Carbon::now()->format('YmdHisv'),
        'user_id' => $shipment['user_id'],
        'amount' => $current_price,
        'wallet_amount' => $wallet['amount'],
        'content' => $history_wallet_content,
        'kind' => $history_wallet_kind,
    ]);

    return [
        "status" => HTTP_OK,
        "message" => "Thao tác thành công"
    ];
}


function saveHistoryDebit($table, $user_id, $manager_id, $amount, $kind, $content)
{
    DB::table($table)
        ->insert([
            "user_id" => $user_id,
            "manager_id" => $manager_id,
            "content" => $content,
            "amount" => $amount,
            "kind" => $kind,
            "created_at" => Carbon::now(),
            "updated_at" => Carbon::now(),
        ]);
}

function actionCheckedPaymentShipment($kind, $code, $type)
{
    try {
        $shipments = null;
        switch ($kind) {
            case 0:
                $shipments = Shipment::isShow()->where('shipment_code', $code);
                break;

            case 1:
                $debit = Debit::isShow()->where('debit_no', $code)->first();
                $shipments = Shipment::isShow()->where('shipment_debit_id', $debit['debit_id']);

                if ($type == 0) {
                    $debit->debit_status = 0;
                    $debit->debit_images = null;
                    $debit->debit_payment_date = null;
                    $debit->debit_payment_amount = 0;
                    $debit->debit_note = null;
                    $debit->debit_advance_images = null;
                    $debit->debit_advance_note = null;
                    $debit->save();
                }
                break;

            case 2:
                $debit_ids = Statement::isShow()
                    ->leftJoin('statement_items', 'statements.statement_id', 'statement_items.statement_id')
                    ->where('statement_code', $code)->pluck('debit_id');
                $shipments = Shipment::isShow()->whereIn('shipment_debit_id', $debit_ids);

                if ($type == 0) {
                    $statment = Statement::isShow()->where('statement_code', $code)->first();
                    $statment->statement_status = 0;
                    $statment->statement_amount = 0;
                    $statment->statement_images = null;
                    $statment->statement_note = null;
                    $statment->save();

                    Debit::isShow()->whereIn('debit_id', $debit_ids)->update([
                        'debit_status' => 0,
                        'debit_images' => null,
                        'debit_payment_date' => null,
                        'debit_payment_amount' => 0,
                        'debit_note' => null,
                        'debit_advance_images' => null,
                        'debit_advance_note' => null,
                    ]);
                }
                break;

            default:
                # code...
                return;
        }

        $shipments->update(['checked_payment_status' => $type]);
    } catch (\Throwable $th) {
    }
}

function onConfirmCheckedItemPaymentByAdmin($kind, $code)
{
    // kind: loại shipment/debit/statement
    // Mã của đơn
    try {
        switch ($kind) {
            case 0:
                Shipment::where('shipment_code', $code)->update(['checked_payment_status' => 1]);
                break;

            case 1:
                $debit = Debit::isShow()->where('debit_no', $code)->first();
                if ($debit) {
                    Debit::find($debit['debit_id'])->update(['checked_payment_status' => 1]);
                    Shipment::where('shipment_debit_id', $debit['debit_id'])->update(['checked_payment_status' => 1]);
                }
                break;

            case 2:
                $statement = Statement::isShow()->where('statement_code', $code)->first();
                if ($statement) {
                    $debit_ids = Statement::isShow()
                        ->leftJoin('statement_items', 'statements.statement_id', 'statement_items.statement_id')
                        ->where('statement_code', $code)->pluck('debit_id');

                    Statement::find($statement['statement_id'])->update(['checked_payment_status' => 1]);
                    Debit::isShow()->whereIn('debit_id', $debit_ids)->update(['checked_payment_status' => 1]);
                    Shipment::isShow()
                        ->whereIn('shipment_debit_id', $debit_ids)
                        ->update(['checked_payment_status' => 1]);
                }
                break;

            default:
                # code...
                break;
        }
    } catch (\Throwable $th) {
        //throw $th;
    }
}

// Chức năng dùng cho Xác nhận thanh toán/ Hoàn lại xác nhận, Không dùng cho Hủy đơn
function onConfirmCheckedPaymentByAdmin($kind, $code, $type)
{
    // kind: loại shipment/debit/statement
    // Mã của đơn
    // type: Xác nhận/ hoàn lại thanh toán

    $shipment_update = ['checked_payment_status' => $type == 0 ? 0 : 1];
    $debit_update = ['checked_payment_status' => $type == 0 ? 0 : 1];
    $statement_update = ['checked_payment_status' => $type == 0 ? 0 : 1];
    try {
        switch ($kind) {
            case 0:
                Shipment::where('shipment_code', $code)->update($shipment_update);
                break;

            case 1:
                $debit = Debit::isShow()->where('debit_no', $code)->first();
                if ($debit) {
                    Debit::find($debit['debit_id'])->update($debit_update);
                    Shipment::where('shipment_debit_id', $debit['debit_id'])->update($shipment_update);
                }
                break;

            case 2:
                $statement = Statement::isShow()->where('statement_code', $code)->first();
                if ($statement) {
                    $debit_ids = Statement::isShow()
                        ->leftJoin('statement_items', 'statements.statement_id', 'statement_items.statement_id')
                        ->where('statement_code', $code)->pluck('debit_id');

                    Statement::find($statement['statement_id'])->update($statement_update);
                    Debit::isShow()->whereIn('debit_id', $debit_ids)->update($debit_update);
                    Shipment::isShow()
                        ->whereIn('shipment_debit_id', $debit_ids)
                        ->update($shipment_update);
                }
                break;

            default:
                # code...
                break;
        }
    } catch (\Throwable $th) {
    }
}


function getPriceListUser($user_id)
{
    try {
        return PriceListUser::isShow()->where('user_id', $user_id)
            ->leftJoin('price_list', 'price_list_user.price_list_id', 'price_list.price_list_id')
            ->select('price_list.*')->first();
    } catch (\Throwable $th) {
        return null;
    }
}

function onCheckAcctionShipment($shipment, $user, $shipment_id = null)
{
    try {
        $checkeds = [
            'is_edit' => true,
        ];
        if ($shipment_id) {
            $shipment = Shipment::isShow()->where('shipment_id', $shipment_id)->first();
        }

        if (onCheckPositionAccounts([SETTING_FWD_ACCOUNT, SETTING_SALE_ACCOUNT], $user['position_id']) && $shipment['shipment_status'] != SHIPMENT_STATUS_CREATE) {
            $checkeds['is_edit'] = false;
        }
        return $checkeds;
    } catch (\Throwable $th) {
        return [
            'is_edit' => false,
        ];
    }
}

function onSetInfoDebitForExport($sheet, $user, $num_start, $info_debit)
{
    try {
        $branch = Branch::isShow()->where('branch_id', $user['branch_id'])->first();
        $path = strtolower($branch['branch_name']);

        $sheet->setCellValue("A$num_start", '* Thông Tin Tài Khoản Chuyển khoản chi nhánh ' . $branch['branch_name']);
        $sheet->getStyle("A$num_start")->applyFromArray([
            'font' => [
                'color' => ['argb' => 'FF0000'], // 
            ],
        ]);
        $content_personal_account = $info_debit['footer'][$path] ?? $info_debit['footer']['hcm'] ?? [];
        foreach ($content_personal_account as $key => $personal_account) {
            $num_start = $num_start + 1;
            $sheet->setCellValue("A$num_start", $personal_account);
        }

        return $sheet;
    } catch (\Throwable $th) {
        return $sheet;
    }
}

function onInActiveAccountSaleAndFwdThirtyDaysAgo()
{
    try {
        $kind = SETTING_FWD_ACCOUNT;
        $path = 'public/config/system-settings.json';
        $system_settings = json_decode(Storage::get($path), true);
        $account = collect($system_settings);
        $fwd_position = $account->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'] ?? null;
        $sale_position = $account->firstWhere('kind', SETTING_SALE_ACCOUNT)['position_id'] ?? null;
        $thirtyDaysAgo = Carbon::now()->subDays(30);

        $user_ids = User::isShow()
            ->leftJoin('shipments', 'users.user_id', '=', 'shipments.user_id')
            ->where(function ($query) use ($thirtyDaysAgo) {
                $query->whereNull('shipments.created_at')
                    ->orWhere('shipments.created_at', '<', $thirtyDaysAgo);
            })
            ->whereIn('position_id', [$sale_position, $fwd_position])
            ->select('users.user_id')
            ->distinct()
            ->pluck('user_id')->toArray();

        if (!empty($user_ids)) {
            DB::beginTransaction();
            User::isShow()->whereIn('user_id', $user_ids)->update(['active_flg' => INACTIVE]);
            DB::commit();
        }
    } catch (\Throwable $th) {
        DB::rollBack();
    }
}

function onShowOriginAmountStatement($code, $price_payment = 0)
{
    try {
        $statement = Statement::isShow()
            ->where('statements.statement_code', $code)
            ->join('statement_items', 'statements.statement_id', '=', 'statement_items.statement_id')
            ->where('statement_items.delete_flg', NO_DELETE)->where('statement_items.active_flg', ACTIVE)
            ->leftJoin('debits', 'statement_items.debit_id', '=', 'debits.debit_id')
            ->leftJoin('shipments', 'statement_items.debit_id', '=', 'shipments.shipment_debit_id')
            ->select(
                DB::raw('SUM(shipment_final_amount) as total_price'),
                'statements.statement_id'
            )
            ->groupBy('statements.statement_id')
            ->first();
        $amount = $statement['total_price'] ?? 0;

        return [
            'amount' => $amount,
            'color' => $amount > $price_payment ? 'danger' : 'success',
            'icon' => $amount > $price_payment ? 'fas fa-exclamation-circle text-danger' : '',
            'text' => $amount > $price_payment ? 'Đơn thanh toán có chênh lệch nhỏ hơn so với tổng tiền' : '',
        ];
    } catch (\Throwable $th) {
        return [
            'amount' => 0,
            'color' => 'danger',
            'icon' => 'fas fa-exclamation-circle text-danger',
            'text' => 'Lỗi không xác định',
        ];
    }
}

function onShowOriginAmountDebit($code, $price_payment = 0)
{
    try {

        $debit = Debit::isShow()
            ->where('debits.debit_no', $code)
            ->leftJoin('shipments', 'debits.debit_id', '=', 'shipments.shipment_debit_id')
            ->where('shipments.delete_flg', NO_DELETE)->where('shipments.active_flg', ACTIVE)
            ->select(
                DB::raw('SUM(shipment_final_amount) as total_price'),
                'debits.debit_id'
            )
            ->groupBy('debits.debit_id')
            ->first();

        $amount = $debit['total_price'] ?? 0;

        return [
            'amount' => $amount,
            'color' => $amount > $price_payment ? 'danger' : 'success',
            'icon' => $amount > $price_payment ? 'fas fa-exclamation-circle text-danger' : '',
            'text' => $amount > $price_payment ? 'Đơn thanh toán có chênh lệch nhỏ hơn so với tổng tiền' : '',
        ];
    } catch (\Throwable $th) {
        return [
            'amount' => 0,
            'color' => 'danger',
            'icon' => 'fas fa-exclamation-circle text-danger',
            'text' => 'Lỗi không xác định ',
        ];
    }
}


function onUpdateUserRemainingLimit($user_id, $user = null)
{
    try {
        if (!$user) {
            $user = User::find($user_id);
        }
        $price = 0;
        if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user['position_id'])) {
            $debit = Debit::isShow()
                ->leftJoin('checked_payment_cashs', 'debits.debit_no', 'checked_payment_cashs.code')
                ->leftJoin('shipments', function ($join) {
                    $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE);
                })
                ->where('debits.customer_id', $user['user_id'])
                ->where('debits.debit_status', '!=', 1)
                ->whereNotNull('debits.debit_advance_date')
                ->select(
                    'debits.customer_id',
                    DB::raw('SUM(shipment_final_amount + shipment_amount_fsc) as total_price'),

                )->groupBy('debits.customer_id')->first();
            $price = $debit['total_price'] ?? 0;
        } else {
            $shipment = Shipment::isShow()
                ->whereIn('shipment_payment_step', [2, 3])
                ->where('shipment_paid_by', SHIPMENT_PAID_BY_REMAINING)
                ->where('shipments.user_id', $user['user_id'])
                ->select(
                    DB::raw('SUM(shipment_amount_total_customer) as total_price'),
                    'shipments.user_id'
                )->groupBy('shipments.user_id')->first();

            $price = $shipment['total_price'] ?? 0;
        }
        User::find($user['user_id'])->update([
            'user_remaining_limit' => $price
        ]);
    } catch (\Throwable $th) {
    }
}

function getMenuUserPosiotion(){
    try {
        $user = request()->user();
        if (!$user) {
            return [
                'status' => 500,
                'message' => 'Bạn chưa đăng nhập',
            ];
        }
        $menu_user_position = MenuByPosition::isPosition($user['position_id'])->get()->toArray();
        $arr_menus = config('constans.menus');

        foreach ($arr_menus as $index => $arr) {
            $menu = $arr['menus'];
            foreach ($menu as $key => $item) {
                $check_have = collect($menu_user_position)->where('menu_key', $key)->first();
                $arr_menus[$index]['menus'][$key]['is_show'] = $check_have ? true : false;
            }
        }

        return [
            'status' => 200,
            'menu' => $arr_menus,
        ];
    } catch (\Throwable $th) {
        return [
            'status' => 500,
            'message' => 'Xảy ra lỗi dưới serve',
            'error' => $th->getMessage(),
        ];
    }
}
