<?php
namespace App\Utils;

use Illuminate\Support\Str;
use App\Models\WeightConversion;
use Illuminate\Support\Facades\Http;

class EtowerApi
{
    const cn_server = 'http://cn.etowertech.com';
    const us_server = 'http://us.etowertech.com';
    const url_test = 'http://qa.etowertech.com';
    const secretKey = '79db9e5OEeOpvgAVXUFWSD'; // 79db9e5OEeOpvgAVXUFWSD , H2daH9s2IJmCQYQ77oEiAQ
    const accessToken = 'test5AdbzO5OEeOpvgAVXUFE0A'; // test5AdbzO5OEeOpvgAVXUFE0A , testqMfBG8xvSKJKT6O2Pz9

    const PATH_SHIPPING_ORDER = '/services/shipper/orders';
    const PATH_PRINT_LABEL = '/services/shipper/labels';

    public function createOrderImportExcel($data)
    {
        try {
            $data = $this->formatDataWhenImportExcel($data);

            $route = self::PATH_SHIPPING_ORDER;
            $method = 'POST';

            $sendData = [$data];

            $response = $this->_callApiData($route, $method, $sendData);
            
            if ($response['status'] == "Success") {
                return [
                    'status' => HTTP_OK,
                    'data' => $response['data']
                ];
            } else {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'data' => $response
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR
            ];
        }
    }

    private function formatDataWhenImportExcel($data)
    {
        $result = [
            "referenceNo" => $data['referenceNo'] ?? Str::random(20),
            "trackingNo" => "",
            "serviceCode" => $data['serviceType'],
            "incoterm" => "",
            "description" => $data['description'],
            "nativeDescription" => "",
            "weight" => $data['weight'],
            "weightUnit" => $data['weightUnit'],
            "length" => $data['length'],
            "width" => $data['width'],
            "height" => $data['height'],
            "volume" => 5000 / 100000,
            "dimensionUnit" => Str::upper($data['dimensionUnit']),
            "invoiceValue" => $data['unitValue'],
            "invoiceCurrency" => "USD",
            "pickupType" => "",
            "authorityToLeave" => "",
            "lockerService" => "",
            "batteryType" => "",
            "batteryPacking" => "",
            "dangerousGoods" => "false",
            "serviceOption" => "",
            "instruction" => "",
            "facility" => "",
            "platform" => "",
            "recipientName" => $data['recipientName'],
            "recipientCompany" => $data['recipientName'],
            "phone" => $data['phone'],
            "email" => "",
            "addressLine1" => $data['addressLine1'],
            "addressLine2" => $data['addressLine2'] ?? '',
            "addressLine3" => "",
            "city" => $data['city'],
            "state" => $data['state'],
            "postcode" => $data['postcode'],
            "country" => $data['country'],
            "shipperName" => 'C.T FREIGHT',
            "shipperPhone" => "13000001111",
            "shipperAddressLine1" => "12-14 Trade Park Drive Tullamarine",
            "shipperAddressLine2" => "",
            "shipperAddressLine3" => "",
            "shipperCity" => "MELBOURNE",
            "shipperState" => "VIC",
            "shipperPostcode" => "3043",
            "shipperCountry" => "AU",
            "returnOption" => "",
            "returnName" => 'C.T FREIGHT',
            "returnAddressLine1" => '12-14 Trade Park Drive Tullamarine',
            "returnAddressLine2" => "",
            "returnAddressLine3" => "",
            "returnCity" => "MELBOURNE",
            "returnState" => "VIC",
            "returnPostcode" => "3043",
            "returnCountry" => "AU",
            "abnnumber" => "",
            "gstexemptioncode" => "",
            "orderItems" => [],
            "extendData" => [
                "agentID" => "TEST",
                "vendorid" => "GB123456789",
                "platformorderno" => "123456"
            ]
        ];
        
        $result['orderItems'][] = [
            "itemNo" => '' . rand(100000000000, 999999999999),
            "sku" => 'S' . rand(1000000000, 9999999999),
            "description" => $data['description'],
            "nativeDescription" => "商品",
            "hsCode" => "",
            "originCountry" => "VN",
            "itemCount" => $data['itemCount'],
            "unitValue" => $data['unitValue'],
            "warehouseNo" => "",
            "productURL" => "",
            "weight" => $data['weight'],
        ];
        return $result;
    }


    private function hmac_sha1($data, $secretAccessKey)
    {
        // Chuyển đổi secretAccessKey thành định dạng byte
        $key = utf8_encode($secretAccessKey);
        // Khởi tạo một đối tượng HMAC SHA1
        $hmac = hash_hmac('sha1', $data, $key, true);
        // Chuyển đổi kết quả HMAC thành định dạng base64
        return base64_encode($hmac);
    }

    private function generateSignature($accessToken, $secretKey, $verb, $date, $fullUrl, $data)
    {
        $dataToSign = $verb . "\n" . $date . "\n" . $fullUrl;
        $secretAccessKey = $secretKey;
        $signature = $this->hmac_sha1($dataToSign, $secretAccessKey);
        return "WallTech " . $accessToken . ":" . $signature;
    }

    private function _callApiData($route, $method = 'GET', $sendData = null)
    {
        // Thông tin cần thiết
        $accessToken = self::accessToken;
        $secretKey = self::secretKey;
        $fullUrl = self::url_test . $route;

        // Tạo header X-WallTech-Date
        $date = gmdate('D, d M Y H:i:s T'); // Thời gian theo định dạng RFC1123

        // Tạo chữ ký cho yêu cầu
        $signature = $this->generateSignature($accessToken, $secretKey, $method, $date, $fullUrl, json_encode($sendData));

        $https = Http::withHeaders([
            "Content-Type" => "application/json",
            'Accept' => 'application/json',
            'User-Agent' => 'Mozilla/5.0',
            'Host' => 'qa.etowertech.com',
            'X-WallTech-Date' => $date,
            'Authorization' => $signature
        ]);

        $response = null;

        // Kiểm tra phương thức HTTP để gửi yêu cầu
        if ($method == 'GET') {
            $response = $https->get($fullUrl)->json();
        } elseif ($method == 'POST') {
            $response = $https->post($fullUrl, $sendData ?: [])->json(); // Xử lý $sendData nếu null
        } elseif ($method == 'PUT') {
            $response = $https->put($fullUrl, $sendData ?: [])->json(); // Xử lý $sendData nếu null
        }

        return $response;
    }


    public function getDevice($id)
    {
        $route = '/api/v1/device/' . $id;
        return $this->_callApiData($route);
    }

    public function getServices()
    {
        $route = '/services/shipper/service-catalog';
        return $this->_callApiData($route);
    }

    public function createShippingOrder($data, $service = null)
    {
        try {
            $data = $this->formatDataOfShipment($data, $service);
            
            $route = self::PATH_SHIPPING_ORDER;
            $method = 'POST';

            $sendData = [$data];

            $res = $this->_callApiData($route, $method, $sendData);

            if ($res['status'] == "Success") {
                return [
                    'status' => HTTP_OK,
                    'data' => $res['data']
                ];
            } else {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'data' => isset($res['errors'][0]) ? [
                        'code' => $res['errors'][0]['code'] ?? 0000000,
                        'message' => $res['errors'][0]['message'] ?? 'Xảy ra lỗi khi call api'
                    ] : $res
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR
            ];
        }
    }

    public function printLabels($data)
    {
        try {
            $sendData = [
                'orderIds' => $data['orderIds'],
                'labelType' => isset($data['labelType']) ? $data['labelType'] : 1,
                'packinglist' => isset($data['packinglist']) ? $data['packinglist'] : false,
                'merged' => isset($data['merged']) ? $data['merged'] : false,
                'labelFormat' => isset($data['labelFormat']) ? $data['labelFormat'] : 'PDF',
            ];
            $route = self::PATH_PRINT_LABEL;
            $method = 'POST';

            $res = $this->_callApiData($route, $method, $sendData);

            if ($res['status'] == "Success") {
                return [
                    'status' => HTTP_OK,
                    'data' => $res['data']
                ];
            } else {
                return [
                    'status' => HTTP_BAD_REQUEST,
                    'data' => $res['errors'][0]
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_BAD_REQUEST,
                'data' => [
                    'code' => 500,
                    'message' => "Xảy ra lỗi dưới serve"
                ]
            ];
        }
    }

    public function formatDataOfShipment($data, $service = null)
    {
        try {
            $data['total_packages'] = collect($data['packages'])->count();
            $data['total_weight'] = collect($data['packages'])->sum('weight');
            $data['total_package_weight'] = collect($data['packages'])->sum('package_weight');
            $data['total_length'] = collect($data['packages'])->sum('length');
            $data['total_width'] = collect($data['packages'])->sum('width');
            $data['total_height'] = collect($data['packages'])->sum('height');
            $data['shipment_goods_name'] = preg_replace('/[^a-zA-Z0-9]/', '', $data['shipment_goods_name']);
            $data['weightUnit'] = "KG";

            $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
                ->where('initial_weight', '>=', $data['total_package_weight'])
                ->first();
            
            if(isset($weight_convert)){
                $data['total_weight'] = $weight_convert->weight_conversion;
                $data['weightUnit'] = $weight_convert->weight_unit;
            }

            $result = [
                "referenceNo" => Str::random(20),
                "trackingNo" => "",
                "serviceCode" => $service ?? "UBI.CN2CA.CPC",
                "incoterm" => "",
                "description" => $data['shipment_goods_name'],
                "nativeDescription" => "",
                "weight" => $data['total_weight'],
                "weightUnit" => $data['weightUnit'],
                "length" => $data['total_length'],
                "width" => $data['total_width'],
                "height" => $data['total_height'],
                "volume" => $data['service_volumetric_mass'] / 100000,
                "dimensionUnit" => "CM",
                "invoiceValue" => $data['shipment_value'],
                "invoiceCurrency" => "USD",
                "pickupType" => "",
                "authorityToLeave" => "",
                "lockerService" => "",
                "batteryType" => "",
                "batteryPacking" => "",
                "dangerousGoods" => "false",
                "serviceOption" => "",
                "instruction" => "",
                "facility" => "",
                "platform" => "",
                "recipientName" => $data['receiver_contact_name'],
                "recipientCompany" => $data['receiver_company_name'],
                "phone" => $data['receiver_telephone'],
                "email" => "",
                "addressLine1" => $data['receiver_address_1'],
                "addressLine2" => "",
                "addressLine3" => "",
                "city" => $data['city_code'],
                "state" => $data['state_name'],
                "postcode" => $data['receiver_postal_code'],
                "country" => $data['country_code'],
                "shipperName" => 'C.T FREIGHT',
                "shipperPhone" => "13000001111",
                "shipperAddressLine1" => $data['sender_address'],
                "shipperAddressLine2" => "",
                "shipperAddressLine3" => "",
                "shipperCity" => "MELBOURNE",
                "shipperState" => "VIC",
                "shipperPostcode" => "3043",
                "shipperCountry" => "VN",
                "returnOption" => "",
                "returnName" => 'C.T FREIGHT',
                "returnAddressLine1" => '12-14 Trade Park Drive Tullamarine',
                "returnAddressLine2" => "",
                "returnAddressLine3" => "",
                "returnCity" => "MELBOURNE",
                "returnState" => "VIC",
                "returnPostcode" => "3043",
                "returnCountry" => $data['country_code'],
                "abnnumber" => "",
                "gstexemptioncode" => "",
                "orderItems" => [],
                "extendData" => [
                    "agentID" => "TEST",
                    "vendorid" => "GB123456789",
                    "platformorderno" => "123456"
                ]
            ];
            
            if (empty($data['invoices'])) {
                $result['orderItems'][] = [
                    "itemNo" => '' . rand(100000000000, 999999999999),
                    "sku" => 'S' . rand(1000000000, 9999999999),
                    "description" => $data['shipment_goods_name'],
                    "nativeDescription" => "商品",
                    "hsCode" => "",
                    "originCountry" => "VN",
                    "itemCount" => $data['total_packages'],
                    "unitValue" => $data['shipment_value'],
                    "warehouseNo" => "",
                    "productURL" => "",
                    "weight" => $data['total_weight'],
                ];
            }else {
                foreach ($data['invoices'] as $invoice) {
                    array_push($result['orderItems'], [
                        "itemNo" => '' . rand(100000000000, 999999999999),
                        "sku" => 'S' . rand(1000000000, 9999999999),
                        "description" => preg_replace('/[^a-zA-Z0-9]/', '', $invoice['invoice_goods_details']),
                        "nativeDescription" => "商品",
                        "hsCode" => "",
                        "originCountry" => "VN",
                        "itemCount" => $invoice['invoice_quantity'],
                        "unitValue" => $invoice['invoice_total_price'],
                        "warehouseNo" => "",
                        "productURL" => "",
                        "weight" => $data['total_weight'],
                    ]);
                }
            }
            return $result;
        } catch (\Throwable $th) {
            return [];
        }
    }
}
