<?php
namespace App\Utils;

use App\Models\Service;
use App\Models\WeightConversion;
use Illuminate\Support\Str;

class DmxSmartApi
{
    const url = 'https://api.dmxsmart.com/api/openapi/v12/services';
    const appId = 'omVeQnIJ';
    const appKey = 'ae9bbb6f0c9843e69a6d1e6c24ad489a';
    const appSecret = '64bceaeb1f09480897102a4b482083f5';
    const language = 'en';
    const TMS_SHIPMENT_CREATE = 'tms.shipment.create';
    const TMS_SHIPMENT_GET_LABEL = 'tms.shipment.getLabel';
    const SERVICE_CODE_OF_USA_USPSGA = 'USPSGA';
    const SERVICE_CODE_OF_USA_UPSGND = 'UPSGND';

    public function createShipmentWithServiceCodeOfUPS($businessParams)
    {
        return $this->createShipment(self::SERVICE_CODE_OF_USA_USPSGA, $businessParams);
    }

    public function createShipmentWithServiceCodeOfUPSGROUND($businessParams)
    {
        return $this->createShipment(self::SERVICE_CODE_OF_USA_UPSGND, $businessParams);
    }

    public function createShipment($serviceCode, $businessParams)
    {
        $businessParams = collect($businessParams)->toArray();
        $businessParams['total_weight'] = collect($businessParams['packages'])->sum('weight');
        $businessParams['total_package_weight'] = collect($businessParams['packages'])->sum('package_weight');
        $businessParams['boxQty'] = collect($businessParams['packages'])->count();
        $businessParams['signatureRequired'] = $businessParams['shipment_signature_flg'] == SHIPMENT_SIGNATURE_NO ? "No" : "Yes";
        $businessParams['weightUnit'] = "kg";

        $weight_convert = WeightConversion::where('service_id', $businessParams['shipment_service_id'])
            ->where('initial_weight', '>=', $businessParams['total_package_weight'])
            ->first();
        
        if(isset($weight_convert)){
            $businessParams['total_weight'] = $weight_convert->weight_conversion;
            $businessParams['weightUnit'] = Str::lower($weight_convert->weight_unit);
        }

        $businessParams['products'] = collect($businessParams['invoices'])->map(function ($invoice) {
            return [
                'qty' => $invoice['invoice_quantity'],
                'sku' => Str::slug($invoice['invoice_goods_details']),
            ];
        })->toArray();

        $result = [
            "syncGetLabel" => false,
            "referenceId" => isset($businessParams['shipment_reference_code']) ? $businessParams['shipment_reference_code'] : Str::random(30),
            "referenceId2" => isset($businessParams['shipment_reference_code']) ? $businessParams['shipment_reference_code'] : Str::random(30),
            "referenceId3" => isset($businessParams['shipment_reference_code']) ? $businessParams['shipment_reference_code'] : Str::random(30),
            "trackingNo" => Str::random(30),
            "entryPoint" => "LAX",
            "serviceCode" => $serviceCode,
            "clearanceType" => 0,
            "dutyType" => "DDP",
            "dimensionUnit" => "cm",
            "weight" => $businessParams['total_weight'],
            "weightUnit" => $businessParams['weightUnit'],
            "customsCurrency" => "USD",
            "boxQty" => $businessParams['boxQty'],
            "signatureRequired" => $businessParams['signatureRequired'],
            "packageType" => 'pak',
            "shipper" => [
                "name" => "KANGO",
                "company" => "KANGO LOG TRANS CO., LTD",
                "addressLine1" => "HCM,VN",
                "addressLine2" => "",
                "county" => "VN",
                "city" => "Ho Chi Minh",
                "state" => "Ho Chi Minh",
                "countryCode" => "VN",
                "zip" => "700000",
                "phone" => "13000001111",
                "email" => "",
                "idNo" => "",
                "taxNoType" => "VAT",
                "taxNoIssuerCountryCode" => "VN"
            ],
            "consignee" => [
                "name" => $businessParams['receiver_contact_name'],
                "company" => $businessParams['receiver_company_name'],
                "roomNo" => "701",
                "addressLine1" => $businessParams['receiver_address_1'],
                "addressLine2" => "",
                "county" => $businessParams['country_name'],
                "city" => $businessParams['city_code'],
                "state" => $businessParams['state_code'],
                "countryCode" => $businessParams['country_code'],
                "zip" => $businessParams['receiver_postal_code'],
                "phone" => $businessParams['receiver_telephone'],
                "taxNoType" => "VAT",
                "taxNoIssuerCountryCode" => "US"
            ],
            "products" => $businessParams['products'],
            "customs" => [],
            "boxes" => [],
        ];

        foreach ($businessParams['packages'] as $key => $package) {
            array_push($result['customs'], [
                'sku' => Str::slug($businessParams['shipment_goods_name']) . $key,
                'localDescription' => $businessParams['shipment_goods_name'],
                'destDescription' => $businessParams['shipment_goods_name'],
                'unitValue' => $businessParams['shipment_value'],
                'unitWeight' => $package['weight'],
                'qty' => 1,
            ]);

            array_push($result['boxes'], [
                "boxQty" => 1,
                "length" => $package['length'],
                "width" => $package['width'],
                "height" => $package['height'],
                "weight" => $package['weight'],
                "products" => []
            ]);
        }
        return $this->_callApiData(self::TMS_SHIPMENT_CREATE, $result);
    }

    public function _callApiData($method, $businessParams)
    {
        try {
            $url = self::url;
            $appId = self::appId;
            $appKey = self::appKey;
            $appSecret = self::appSecret;
            $language = self::language;
            $timestamp = time();

            // Bước 1: Tạo chuỗi signA
            $signA = "appId=$appId&appKey=$appKey&language=$language&method=$method&timestamp=$timestamp";

            // Bước 2: Nén JSON của tham số kinh doanh và tạo signB
            $businessParamsEncode = json_encode($businessParams);
            $compressedBusinessParams = str_replace([' ', "\n", "\r"], '', $businessParamsEncode);
            $signB = $signA . $compressedBusinessParams;

            // Bước 3: Kết nối appSecret để tạo signC
            $signC = $signB . $appSecret;

            // Bước 4: Mã hóa MD5 để tạo giá trị chữ ký 32-bit chữ thường của signC
            $md5Hash = md5($signC);

            $headers = [
                'appId:' . $appId,
                'appKey:' . $appKey,
                'language:' . $language,
                'method:' . $method,
                'timestamp:' . $timestamp,
                'sign:' . $md5Hash,
                'Content-Type: text/plain'
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $compressedBusinessParams);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $response = curl_exec($ch);

            curl_close($ch);

            $response = json_decode($response, true);

            if (isset($response['success']) && $response['success']) {
                if (empty($response['data']['labelBase64s'])) {
                    return [
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'data' => [
                            'errorCode' => HTTP_NOT_FOUND,
                            'errorMessage' => 'No label found',
                            'response' => $response
                        ]
                    ];
                }
                return [
                    'status' => HTTP_OK,
                    'data' => $response['data'],
                    'businessParams' => $businessParams
                ];
            }

            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'data' => $response
            ];
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'data' => [
                    'errorCode' => HTTP_INTERNAL_SERVER_ERROR,
                    'errorMessage' => $th->getMessage()
                ]
            ];
        }
    }
}