<?php
namespace App\Utils;

use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\WeightConversion;
use Illuminate\Support\Facades\Http;

class DPDApi
{
    const DPD_UK_ENDPOINT = 'https://api2.udsww.com/PORTAL/DPDUK/UK-dpd-ship.asmx/Ship';
    const DPD_NL_ENDPOINT = 'https://api2.udsww.com/PORTAL/DPDNL-SHAOKE/NL-dpd-shaoke.asmx/NLShaokeShip';
    const DPD_USERNAME = 'C442712';
    const DPD_PASSWORD = '!Kango231$';
    const DBF = 'C442712';
    const API_KEY = 'RoTF/Za5tb95qc5+MSJ2uqwqpcHBjtAb3Mbjoh3RrRw=';

    public function importLabel($excel)
    {
        $excel['serviceType'] = preg_replace('/\s+/', '', $excel['serviceType']);
        if (Str::upper($excel['serviceType']) == 'DPDUK') {
            return $this->importLabelWithDpdUk($excel);
        } else if (Str::upper($excel['serviceType']) == 'DPDNL') {
            return $this->importLabelWithDpdNl($excel);
        }
    }

    public function importLabelWithDpdUk($data)
    {
        $data['total_weight'] = floatval($data['itemCount']) * floatval($data['weight']);

        $result = [
            "jobId" => null,
            "collectionOnDelivery" => false,
            "generateCustomsData" => null,
            "invoice" => null,
            "collectionDate" => Carbon::now()->toISOString(),
            "consolidate" => false,
            "consignment" => [
                [
                    "consignmentNumber" => null,
                    "consignmentRef" => null,
                    "parcel" => [],
                    "collectionDetails" => [
                        "contactDetails" => [
                            "contactName" => 'KANGO',
                            "telephone" => '13000001111',
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => "",
                            "countryCode" => "",
                            "postcode" => "",
                            "street" => "",
                            "locality" => "",
                            "town" => "",
                            "county" => ""
                        ]
                    ],
                    "deliveryDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['recipientName'],
                            "telephone" => $data['phone'],
                            "email" => $data['email']
                        ],
                        "address" => [
                            "organisation" => $data['recipientName'],
                            "countryCode" => $data['country'],
                            "postcode" => $data['postcode'],
                            "street" => $data['addressLine1'] . (isset($data['addressLine2']) ? ', ' . $data['addressLine2'] : ''),
                            "locality" => null,
                            "town" => $data['city'],
                            "county" => $data['state']
                        ],
                        "notificationDetails" => array(
                            "email" => "info@kangoexp.vn",
                            "mobile" => "13000001111"
                        )
                    ],
                    "networkCode" => "1^12",
                    "numberOfParcels" => $data['itemCount'],
                    "totalWeight" => $data['total_weight'],
                    "shippingRef1" => $data['referenceNo'] ?? rand(1000000000, 9999999999),
                    "shippingRef2" => "REF DPD UK",
                    "shippingRef3" => "C442712",
                    "customsCurrency" => null,
                    "customsValue" => 0,
                    "deliveryInstructions" => null,
                    "parcelDescription" => "SAMPLES",
                    "liabilityValue" => 0,
                    "liability" => false,
                    "shippersDestinationTaxId" => null,
                    "vatPaid" => null
                ]
            ]
        ];

        foreach ($data['childOrders'] as $key => $package) {
            array_push($result['consignment'][0]['parcel'], [
                "packageNumber" => 1,
                "pieces" => 1,
                "weight" => $package['weight'],
                "parcelProducts" => null
            ]);
        }

        $response = $this->createShipment(self::DPD_UK_ENDPOINT, $result);
 
        if (isset($response['d']['Status']) && $response['d']['Status'] == "OK") {
            $response['d']['serviceType'] = 'DPD UK';
            $response['d']['referenceNo'] = $data['referenceNo'];
            return [
                "status" => HTTP_OK,
                "data" => $response['d']
            ];
        } else {
            return [
                "status" => HTTP_INTERNAL_SERVER_ERROR,
                "data" => $response
            ];
        }
    }

    public function importLabelWithDpdNl($data)
    {
        $data['total_weight'] = floatval($data['itemCount']) * floatval($data['weight']);

        $result = [
            "jobId" => null,
            "collectionOnDelivery" => false,
            "generateCustomsData" => null,
            "invoice" => null,
            "collectionDate" => Carbon::now()->toISOString(),
            "consolidate" => false,
            "consignment" => [
                [
                    "consignmentNumber" => null,
                    "consignmentRef" => null,
                    "parcel" => [],
                    "collectionDetails" => [
                        "contactDetails" => [
                            "contactName" => 'KANGO',
                            "telephone" => '13000001111',
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => "Universal Delivery Solutions",
                            "countryCode" => "VN",
                            "postcode" => "70000",
                            "street" => "Go Vap",
                            "locality" => "",
                            "town" => "Ho Chi Minh",
                            "county" => "Ho Chi Minh"
                        ]
                    ],
                    "deliveryDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['recipientName'],
                            "telephone" => $data['phone'],
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => $data['recipientName'],
                            "countryCode" => $data['country'],
                            "postcode" => $data['postcode'],
                            "street" => $data['addressLine1'] . (isset($data['addressLine2']) ? ', ' . $data['addressLine2'] : ''),
                            "locality" => null,
                            "town" => $data['city'],
                            "county" => $data['state']
                        ],
                        "notificationDetails" => [
                            "email" => "info@kangoexp.vn",
                            "mobile" => "13000001111"
                        ]
                    ],
                    "networkCode" => "1^12",
                    "numberOfParcels" => $data['itemCount'],
                    "totalWeight" => $data['total_weight'] * 100,
                    "shippingRef1" => $data['referenceNo'] ?? rand(1000000000, 9999999999),
                    "shippingRef2" => "REF DPD NL",
                    "shippingRef3" => self::DBF,
                    "customsCurrency" => null,
                    "customsValue" => $data['unitValue'],
                    "deliveryInstructions" => null,
                    "parcelDescription" => "SAMPLES",
                    "liabilityValue" => $data['unitValue'],
                    "liability" => false,
                    "shippersDestinationTaxId" => null,
                    "vatPaid" => null
                ]
            ]
        ];

        foreach ($data['childOrders'] as $key => $package) {
            array_push($result['consignment'][0]['parcel'], [
                "packageNumber" => 1,
                "pieces" => 1,
                "weight" => $package['weight'],
                "parcelProducts" => null
            ]);
        }
        
        $response = $this->createShipment(self::DPD_NL_ENDPOINT, $result);

        if (isset($response['d']['code']) && $response['d']['code'] == HTTP_OK) {
            $response['d']['pdf'] = $response['d']['data']['label_link'];
            $response['d']['shipmentid'] = $response['d']['data']['client_ref'];
            $response['d']['serviceType'] = 'DPD NL';
            $response['d']['referenceNo'] = $data['referenceNo'];
            return [
                "status" => HTTP_OK,
                "data" => $response['d']
            ];
        } else {
            return [
                "status" => HTTP_INTERNAL_SERVER_ERROR,
                "data" => $response
            ];
        }
    }

    public function createShipmentWithDpdUk($data)
    {
        $data = $this->convertDataUk($data);
        $response = $this->createShipment(self::DPD_UK_ENDPOINT, $data);

        if (isset($response['d']['Status']) && $response['d']['Status'] == "OK") {
            $response['d']['reference_no'] = $data['consignment'][0]['shippingRef1'];
            return [
                "status" => HTTP_OK,
                "data" => $response['d']
            ];
        } else {
            return [
                "status" => HTTP_INTERNAL_SERVER_ERROR,
                "data" => $response
            ];
        }
    }

    public function createShipmentWithDpdNl($data)
    {
        $data = $this->convertDataNl($data);
        $response = $this->createShipment(self::DPD_NL_ENDPOINT, $data);
        
        if (isset($response['d']['code']) && $response['d']['code'] == HTTP_OK) {
            $response['d']['reference_no'] = $data['consignment'][0]['shippingRef1'];
            return [
                "status" => HTTP_OK,
                "data" => $response['d']
            ];
        } else {
            return [
                "status" => HTTP_INTERNAL_SERVER_ERROR,
                "data" => $response
            ];
        }
    }

    private function createShipment($url, $data)
    {
        $response = Http::withHeaders([
            "Content-Type" => "application/json",
            'Accept' => 'application/json',
            'Authorization' => 'Basic ' . base64_encode(self::DPD_USERNAME . ':' . self::DPD_PASSWORD),
            'API-KEY' => self::API_KEY,
            'DBF' => 'PORTAL'
        ])->post($url, $data);

        $response = $response->json();

        return $response;
    }

    private function convertDataUk($data)
    {
        $data['total_weight'] = collect($data['packages'])->sum('weight');
        $data['total_package_weight'] = collect($data['packages'])->sum('package_weight');

        $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
            ->where('initial_weight', '>=', $data['total_package_weight'])
            ->first();

        if (isset($weight_convert)) {
            $data['total_weight'] = $weight_convert->weight_conversion;
            $data['weightUnit'] = Str::lower($weight_convert->weight_unit);
        }

        $result = [
            "jobId" => null,
            "collectionOnDelivery" => false,
            "generateCustomsData" => null,
            "invoice" => null,
            "collectionDate" => $data['created_at'],
            "consolidate" => false,
            "consignment" => [
                [
                    "consignmentNumber" => null,
                    "consignmentRef" => null,
                    "parcel" => [],
                    "collectionDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['sender_contact_name'],
                            "telephone" => $data['sender_telephone'],
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => "",
                            "countryCode" => "",
                            "postcode" => "",
                            "street" => "",
                            "locality" => "",
                            "town" => "",
                            "county" => ""
                        ]
                    ],
                    "deliveryDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['receiver_contact_name'],
                            "telephone" => $data['receiver_telephone'],
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => $data['receiver_address_1'],
                            "countryCode" => $data['country_code'],
                            "postcode" => $data['receiver_postal_code'],
                            "street" => $data['receiver_address_1'],
                            "locality" => null,
                            "town" => $data['city_code'],
                            "county" => $data['state_name']
                        ],
                        "notificationDetails" => array(
                            "email" => "info@kangoexp.vn",
                            "mobile" => "13000001111"
                        )
                    ],
                    "networkCode" => "1^12",
                    "numberOfParcels" => count($data['packages']),
                    "totalWeight" => $data['total_weight'],
                    "shippingRef1" => $data['shipment_code'],
                    "shippingRef2" => "REF DPD UK",
                    "shippingRef3" => "C442712",
                    "customsCurrency" => null,
                    "customsValue" => 0,
                    "deliveryInstructions" => null,
                    "parcelDescription" => "SAMPLES",
                    "liabilityValue" => 0,
                    "liability" => false,
                    "shippersDestinationTaxId" => null,
                    "vatPaid" => null
                ]
            ]
        ];

        foreach ($data['packages'] as $key => $package) {
            $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
                ->where('initial_weight', '>=', $package['package_weight'])
                ->first();

            array_push($result['consignment'][0]['parcel'], [
                "packageNumber" => 1,
                "pieces" => 1,
                "weight" => $weight_convert['weight_conversion'] ?? $package['weight'],
                "parcelProducts" => null
            ]);
        }
        return $result;
    }

    private function convertDataNl($data)
    {
        $data['total_weight'] = collect($data['packages'])->sum('weight');
        $data['total_package_weight'] = collect($data['packages'])->sum('package_weight');

        $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
            ->where('initial_weight', '>=', $data['total_package_weight'])
            ->first();

        if (isset($weight_convert)) {
            $data['total_weight'] = $weight_convert->weight_conversion;
            $data['weightUnit'] = Str::lower($weight_convert->weight_unit);
        }

        $result = [
            "jobId" => null,
            "collectionOnDelivery" => false,
            "generateCustomsData" => null,
            "invoice" => null,
            "collectionDate" => Carbon::parse($data['created_at'])->toISOString(),
            "consolidate" => false,
            "consignment" => [
                [
                    "consignmentNumber" => null,
                    "consignmentRef" => null,
                    "parcel" => [],
                    "collectionDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['sender_contact_name'],
                            "telephone" => $data['sender_telephone'],
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => "Universal Delivery Solutions",
                            "countryCode" => "VN",
                            "postcode" => "70000",
                            "street" => "Go Vap",
                            "locality" => "",
                            "town" => "Ho Chi Minh",
                            "county" => "Ho Chi Minh"
                        ]
                    ],
                    "deliveryDetails" => [
                        "contactDetails" => [
                            "contactName" => $data['receiver_contact_name'],
                            "telephone" => $data['receiver_telephone'],
                            "email" => "info@kangoexp.vn"
                        ],
                        "address" => [
                            "organisation" => "KANGO EXPRESS",
                            "countryCode" => $data['country_code'],
                            "postcode" => $data['receiver_postal_code'],
                            "street" => Str::upper($data['receiver_address_1']),
                            "locality" => null,
                            "town" => Str::upper($data['city_code']),
                            "county" => $data['state_name']
                        ],
                        "notificationDetails" => [
                            "email" => "info@kangoexp.vn",
                            "mobile" => "13000001111"
                        ]
                    ],
                    "networkCode" => "1^12",
                    "numberOfParcels" => count($data['packages']),
                    "totalWeight" => $data['total_weight'],
                    "shippingRef1" => $data['shipment_code'],
                    "shippingRef2" => "REF DPD NL",
                    "shippingRef3" => self::DBF,
                    "customsCurrency" => null,
                    "customsValue" => $data['shipment_value'],
                    "deliveryInstructions" => null,
                    "parcelDescription" => "SAMPLES",
                    "liabilityValue" => $data['shipment_value'],
                    "liability" => false,
                    "shippersDestinationTaxId" => null,
                    "vatPaid" => null
                ]
            ]
        ];

        foreach ($data['packages'] as $key => $package) {
            $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
                ->where('initial_weight', '>=', $package['package_weight'])
                ->first();

            array_push($result['consignment'][0]['parcel'], [
                "packageNumber" => 1,
                "pieces" => 1,
                "weight" => $weight_convert['weight_conversion'] ?? $package['weight'],
                "parcelProducts" => null
            ]);
        }

        return $result;
    }
}