<?php

const HTTP_OK = 200;
const HTTP_CREATED = 201;
const HTTP_ACCEPTED = 202;
const HTTP_NO_CONTENT = 204;
const HTTP_BAD_REQUEST = 400;
const HTTP_UNAUTHORIZED = 401;
const HTTP_FORBIDDEN = 403;
const HTTP_NOT_FOUND = 404;
const HTTP_UNPROCESSABLE_ENTITY = 422;
const HTTP_INTERNAL_SERVER_ERROR = 500;
const HTTP_SERVICE_UNAVAILABLE = 503;
const HTTP_GATEWAY_TIMEOUT = 504;
const HTTP_UNKNOWN_ERROR = 520;

const ACTIVE = 1;
const INACTIVE = 0;

const DELETED = 0;
const NO_DELETE = 1;

const LIMITED = 1;
const NO_LIMIT = 0;

const HAVE_TIME_RANGE = 1;
const NO_TIME_RANGE = 0;

const FORGOT_PASSWORD = 0;
const ACCURACY = 1;

const LOGO = 'assets/images/logo-export.png';

const PUBLIC_PATH_USER_SIGNATURE = 'uploads/images/users/signatures';
const PUBLIC_PATH_USER_LOGO = 'uploads/images/users/logos';
const PUBLIC_PATH_ORDER_PICKUP_IMAGE = 'uploads/images/orders-pickup';
const PUBLIC_PATH_SHIPMENT_BARCODE = 'uploads/images/shipment/barcodes';
const PUBLIC_PATH_RECHARGE_IMAGE = 'uploads/images/users/recharges';
const PUBLIC_PATH_PACKAGE_IMAGE = 'uploads/images/users/packages';
const PUBLIC_PATH_SYSTEM_IMAGE = 'uploads/images/system';
const PUBLIC_PATH_TRANSFER_IMAGE = 'uploads/images/transfer';
const PUBLIC_PATH_DEBIT_IMAGE = 'uploads/images/debit';
const PUBLIC_PATH_CREDIT_IMAGE = 'uploads/images/credit';
const PUBLIC_PATH_FINANCIAL_IMAGE = 'uploads/images/financial';
const PUBLIC_PATH_STATEMENT_IMAGE = 'uploads/images/statement';
const PUBLIC_PATH_LOGO_SERVICE = 'uploads/images/logo-service';

const PUBLIC_PATH_SHIPMENT_LABEL = 'uploads/file/shipment/label/';
const PUBLIC_PATH_SHIPMENT_METHOD = 'uploads/file/shipment/method/';
const PUBLIC_PATH_TICKET = 'uploads/file/ticket';

const PUBLIC_PATH_API_DOCUMENT_CONTENT = 'uploads/file/api-document/content';

const SHIPMENT = 0;
const DEBIT = 1;
const STATEMENT = 2;

const NO_PROMOTION = 0;
const IS_PROMOTION = 1;
const IS_EPACKET = 2;

const NOT_DIRECTORY = 0;
const IN_DIRECTORY = 1;

const DATE_RANGE_NO_LIMIT = 0;
const DATE_RANGE_LIMIT = 1;

const USE_CITY = 0;
const USE_SERVICE = 1;

const WEIGHT_RANGE_NO_LIMIT = 0;
const WEIGHT_RANGE_LIMIT = 1;

const SETTING_ALL_ACCOUNT = 0;
const SETTING_SALE_ACCOUNT = 1;
const SETTING_FWD_ACCOUNT = 2;
const SETTING_ACCOUNT_EDIT_ORDER_PICKUP = 3;
const SETTING_COMPANY_NAME = 4;
const SETTING_HEADQUARTERS_ADDRESS = 5;
const SETTING_EMAIL_ADDRESS = 6;
const SETTING_WEBSITE_ADDRESS = 7;
const SETTING_HOTLINE = 8;
const SETTING_ACCOUNT_UPDATE_NOTIFICATIONS = 9;
const SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENTS = 10;
const SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENT_OPERATING_COST = 11;
const SETTING_ACCOUNT_SCAN = 12;
const SETTING_ACCOUNT_TICKET = 13;
const SETTING_SHIPPER_ACCOUNT = 14;
const SETTING_ACCOUNT_DEBITS = 15;
const SETTING_KEY_VNP = 16;
const SETTING_ADMIN_ACCOUNT = 17;
const SETTING_ACCOUNTANT_ACCOUNT = 18;
const SETTING_DOCUMENT_ACCOUNT = 19;
const SETTING_OPS_LEADER_ACCOUNT = 20;
const SETTING_ZALO = 21;
const SETTING_FACEBOOK = 22;
const SETTING_PRINT_BILL_TYPE = 23;
const SETTING_DRIVER_ACCOUNT = 24;

const ORDER_PICKUP_STATUS_WAITING = 0;
const ORDER_PICKUP_STATUS_PENDING_CONFIRM = 1;
const ORDER_PICKUP_STATUS_CONFIRMED = 2;
const ORDER_PICKUP_STATUS_GOING = 3;
const ORDER_PICKUP_STATUS_GONE = 4;
const ORDER_PICKUP_STATUS_PICKED = 5;
const ORDER_PICKUP_STATUS_CANCEL = 6;

const NOTIFICATION_NO_IMPORTANT = 0;
const NOTIFICATION_IMPORTANT = 1;

const NOT_SAVE_RECEIVER = 0;
const SAVE_RECEIVER = 1;

const SHIPMENT_SIGNATURE_NO = 0;
const SHIPMENT_SIGNATURE_YES = 1;

const SHIPMENT_STATUS_CREATE_BILL = 0;
const SHIPMENT_STATUS_BEING_TRANSPORTED_BILL = 1;
const SHIPMENT_STATUS_DELIVERED_BILL = 2;

const SHIPMENT_PAID_BY_WALLET = 0;
const SHIPMENT_PAID_BY_REMAINING = 1;

const SHIPMENT_STATUS_CREATE = 0;
const SHIPMENT_STATUS_IMPORTED = 1;
const SHIPMENT_STATUS_EXPORED = 2;
const SHIPMENT_STATUS_RETURNED = 3;
const SHIPMENT_STATUS_HOLD = 4;
const SHIPMENT_STATUS_TRANSIT_HN = 5;

const PACKAGE_TYPE_CARTON = 0;
const PACKAGE_TYPE_PALLET = 1;
const PACKAGE_TYPE_BAG = 2;

const INVOICE_EXPORT_AS_GIFT = 0;
const INVOICE_EXPORT_AS_SAMPLE = 1;

const INVOICE_UNIT_PCS = 0;
const INVOICE_UNIT_BAG = 1;
const INVOICE_UNIT_BOX = 2;
const INVOICE_UNIT_JAR = 3;
const INVOICE_UNIT_SET = 4;

const PENDING = 0;
const SUCCESS = 1;
const FAIL = 2;

const CASH = 0;
const BANK = 1;
const CASH_AND_BANK = 3;
const WALLET = 2;


const PLUS = 0;
const MINUS = 1;

const PAY_DIRECT = 0;
const PAY_VNPAY = 1;
const PAY_USDT = 2;
const PAY_PERSONAL = 3;

const vnp_HashSecret = 'HXLWOUJIZFNAFPUIAXGAXHWADGPKGBOB';
const vnp_TmnCode = '8LIG7JEX';

const PRICE_LIST_TYPE_SERVICE = 0;
const PRICE_LIST_TYPE_DELIVERY = 1;

const SERVICE_TRANSPORT_SEA = 0;
const SERVICE_TRANSPORT_AIR = 1;

const CHILD_PRICE_LIST_KIND_TRANSPORT_SEA = 0;
const CHILD_PRICE_LIST_KIND_TRANSPORT_AIR = 1;
const CHILD_PRICE_LIST_KIND_TRANSPORT_OTHER = 2;

const SUB_CHILD_PRICE_LIST_TYPE_OTHER = 0;
const SUB_CHILD_PRICE_LIST_TYPE_COUNTRY = 1;
const SUB_CHILD_PRICE_LIST_TYPE_STATE = 2;
const SUB_CHILD_PRICE_LIST_TYPE_CITY = 3;
const SUB_CHILD_PRICE_LIST_TYPE_POST_CODE = 4;

const ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER = 0;
const ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER = 1;
const ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER = 2;
const ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER = 3;

const PAYMENT_METHOD_CASH = 0;
const PAYMENT_METHOD_BANK = 1;
const PAYMENT_METHOD_WALLET = 2;

const OPERATING_COST_PENDING_COMPUTE = 0;
const OPERATING_COST_AUTO_COMPUTE = 1;

const OPERATING_COST_TYPE_NORMAL = 0;
const OPERATING_COST_TYPE_MULTIPLE = 1;

const OPERATING_COST_NO_USE_NUMBER_PACKAGES = 0;
const OPERATING_COST_USE_NUMBER_PACKAGES = 1;

const TICKET_TYPE_TEXT = 0;
const TICKET_TYPE_FILE = 1;

const TICKET_KIND_SHIPMENT = 1;
const TICKET_KIND_PAYMENT = 2;
const TICKET_KIND_OTHER = 0;

const TICKET_STATUS_PENDING = 0;
const TICKET_STATUS_PROCESSING = 1;
const TICKET_STATUS_DONE = 2;


const DEBIT_TYPE_DAY = 1;
const DEBIT_TYPE_WEEK1 = 2;
const DEBIT_TYPE_WEEK2 = 3;
const DEBIT_TYPE_MONTH = 4;

const SMS_HISTORY_BILL = 0;
const SMS_HISTORY_HOLIDAY = 1;

const SALE_MEMBER = 0;
const SALE_LEADER = 1;

const API_LABEL_SHIPSAO = 1;
const API_LABEL_DMXSMART_USPSGA = 2;
const API_LABEL_DMXSMART_UPSGND = 3;
const API_LABEL_AUSPOST = 4;
const API_LABEL_ETOWER = 5;
const API_LABEL_WORLDTECH_HERMES = 6;
const API_LABEL_WORLDTECH_NZ_POST = 7;
const API_LABEL_WORLDTECH_DHL = 8;
const API_LABEL_DPD_UK_HERMES = 9;
const API_LABEL_DPD_NL_HERMES = 10;
const API_LABEL_UBI_AU2AU_PRIORITY = 11;
const API_LABEL_UBI_AU2AU_IPEC = 12;
const API_TOP_LOGISTICS_API = 13;
const API_TOP_LOGISTICS_ONLY_LABEL = 14;

const TIME_EXPIRED_PAYMENT = 10;


const SHIPMENT_NOT_APPROVED = 0;
const SHIPMENT_APPROVED = 1;

const INTERNAL_SURCHARGE = 0; // Phụ thu TRONG hệ thống
const EXTERNAL_SURCHARGE = 1; // Phụ thu NGOÀI hệ thống

const PACKAGE_APPROVE_WAITING = 0;
const PACKAGE_APPROVE_PAID = 1;
const PACKAGE_APPROVE_HAVE_MORE_MONEY = 2;
const PACKAGE_APPROVE_PAYMENT_FAIL = 3;


const URL_TRACKING = 'https://tracking.ksnpost.com/';

const USER_TYPE_F0 = 0;
const USER_TYPE_F1 = 1;

const VAT = 0.08;

