<?php
namespace App\Utils;

use Illuminate\Support\Str;
use App\Models\WeightConversion;
use Illuminate\Support\Facades\Http;

class AusPostApi
{
    const API_URL = 'https://digitalapi.auspost.com.au/shipping/v1';
    const USERNAME = '0fd3ca8e-5b39-4ece-84b0-c354170e7e7f';
    const SECRET = 'bM90wsqqlgRMo2bkXISd';
    const ACCOUNT_NUMBER_1 = '0004985452';

    const PATH_CREATE_SHIPMENTS = '/shipments';
    const PATH_CREATE_LABELS = '/labels';
    const PATH_GET_LABEL = '/labels/';

    public function createShipments($data)
    {
        $result = [
            "shipments" => [
                [
                    "shipment_reference" => Str::random(30),
                    "customer_reference_1" => "",
                    "customer_reference_2" => "",
                    "email_tracking_enabled" => false,
                    "from" => [
                        "name" => "Solid logistics pty ltd - NSW",
                        "lines" => [
                            "U 5 1801 BOTANY RD"
                        ],
                        "suburb" => "BANKSMEADOW",
                        "state" => "NSW",
                        "postcode" => "2019",
                        "phone" => "19009475",
                        "email" => "noreply@kangoexp.vn"
                    ],
                    "to" => [
                        "name" => $data['receiver_contact_name'],
                        "business_name" => $data['receiver_company_name'],
                        "lines" => [
                            $data['receiver_address_1']
                        ],
                        "suburb" => Str::upper($data['city_code']),
                        "state" => $data['state_code'],
                        "postcode" => $data['receiver_postal_code'],
                        "phone" => $data['receiver_telephone'],
                        "email" => "noreply@kangoexp.vn"
                    ],
                    "items" => []
                ]
            ]
        ];

        foreach ($data['packages'] as $package) {
            $weight_convert = WeightConversion::where('service_id', $data['shipment_service_id'])
                ->where('initial_weight', '>=', $package['package_weight'])
                ->first();

            array_push($result['shipments'][0]['items'], [
                "item_description" => $data['shipment_goods_name'],
                "item_reference" => Str::random(30),
                "length" => $package['length'],
                "height" => $package['height'],
                "weight" => isset($weight_convert) ? $weight_convert->weight_conversion : $package['weight'],
                "product_id" => '3J55',
                "width" => $package['width'],
                "contains_dangerous_goods" => false,
                "transportable_by_air" => false,
            ]);
        }

        $response = $this->_callApiData(self::PATH_CREATE_SHIPMENTS, 'POST', $result);
        if ($response['status'] == HTTP_OK) {
            return $this->createLabels($response['data']);
        } else {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'data' => $response['data']
            ];
        }
    }

    public function createLabels($data)
    {
        $result = [
            "wait_for_label_url" => true,
            "unlabelled_articles_only" => false,
            "preferences" => [
                [
                    "type" => "PRINT",
                    "groups" => [
                        [
                            "group" => "Parcel Post",
                            "layout" => "A4-1pp",
                            "branded" => true,
                            "left_offset" => 0,
                            "top_offset" => 0
                        ],
                        [
                            "group" => "Express Post",
                            "layout" => "A4-1pp",
                            "branded" => false,
                            "left_offset" => 0,
                            "top_offset" => 0
                        ]
                    ]
                ]
            ],
            "shipments" => []
        ];

        foreach ($data['shipments'] as $key_shipment => $shipment) {
            $result['shipments'][$key_shipment] = [
                "shipment_id" => $shipment['shipment_id'],
                "items" => []
            ];
            foreach ($shipment['items'] as $key_item => $item) {
                $result['shipments'][$key_shipment]['items'][$key_item] = [
                    "item_id" => $item['item_id']
                ];
            }
        }

        $response = $this->_callApiData(self::PATH_CREATE_LABELS, 'POST', $result);

        if ($response['status'] == HTTP_OK) {
            return [
                'status' => HTTP_OK,
                'data' => $response['data']
            ];
        }
        
        return [
            'status' => HTTP_INTERNAL_SERVER_ERROR,
            'data' => $response['data']
        ];
    }

    public function getLabel($request_id)
    {
        $url = self::API_URL . self::PATH_GET_LABEL . $request_id;

        $response = $this->_callApiData($url, 'GET');

        return [
            'status' => HTTP_OK,
            'data' => $response
        ];
    }

    public function _callApiData($route, $method, $data = [])
    {
        try {
            $url = self::API_URL . $route;
            $username = self::USERNAME;
            $secret = self::SECRET;
            $account_number = self::ACCOUNT_NUMBER_1;

            $authorization = base64_encode("$username:$secret");

            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'Account-Number' => $account_number,
                'Authorization' => "Basic $authorization",
            ]);

            if ($method == 'GET') {
                $response = $response->get($url);
            } else if ($method == 'POST') {
                $response = $response->post($url, $data);
            }

            $response = $response->json();

            if (empty($response['errors'])) {
                return [
                    'status' => HTTP_OK,
                    'data' => $response
                ];
            } else {
                return [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'data' => $response
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_INTERNAL_SERVER_ERROR
            ];
        }
    }
}